/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.profile.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.profile.custom.requests.CustomCreateElementRequestAdapter;
import org.eclipse.papyrus.uml.diagram.profile.custom.ui.dialog.ChooseSetMetaclassDialog;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomSemanticCreateCommand
extends AbstractTransactionalCommand {
    private CustomCreateElementRequestAdapter customRequestAdapter;
    private ArrayList<?> addedMetaclasses;
    private Profile profile;

    public CustomSemanticCreateCommand(TransactionalEditingDomain domain, CustomCreateElementRequestAdapter requestAdapter, Profile profile) {
        super(domain, "Create Custom Semantic Command for Metaclass", null);
        this.profile = profile;
        this.customRequestAdapter = requestAdapter;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = CommandResult.newCancelledCommandResult();
        ChooseSetMetaclassDialog cmcd = new ChooseSetMetaclassDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.profile);
        Shell message = new Shell(new Shell(), 66800);
        message.setText(Messages.CustomSemanticCreateCommand_MetaclassImport0);
        message.setImage(ImageManager.IMG_METACLASS);
        message.setSize(250, 100);
        Label label = new Label((Composite)message, 0);
        label.setText(Messages.CustomSemanticCreateCommand_FetchingMetaclasses);
        label.setBounds(20, 15, 150, 20);
        message.open();
        cmcd.open();
        message.close();
        if (cmcd.getReturnCode() == 0) {
            this.addedMetaclasses = cmcd.getSelectedElements();
            if (!this.addedMetaclasses.isEmpty()) {
                ICommand createElementImportCommand = this.getImportElementCommand();
                if (createElementImportCommand != null) {
                    createElementImportCommand.execute(progressMonitor, info);
                }
                return CommandResult.newOKCommandResult();
            }
        }
        return result;
    }

    private ICommand getImportElementCommand() {
        CompositeCommand addindCommand = new CompositeCommand("Add ImportElement Command");
        EList metaclassSet = this.profile.getReferencedMetaclasses();
        int i = 0;
        while (i < this.addedMetaclasses.size()) {
            if (!metaclassSet.contains(this.addedMetaclasses.get(i))) {
                ElementImport ei = UMLFactory.eINSTANCE.createElementImport();
                ei.setImportedElement((PackageableElement)this.addedMetaclasses.get(i));
                ei.setAlias(((NamedElement)this.addedMetaclasses.get(i)).getName());
                ElementImport added = ei;
                EList list = this.profile.getElementImports();
                int iter = 0;
                while (iter < list.size()) {
                    if (list.get(iter) != null && ((ElementImport)list.get(iter)).getImportedElement() != null && ei.getImportedElement().getQualifiedName().equals(((ElementImport)list.get(iter)).getImportedElement().getQualifiedName())) {
                        added = (ElementImport)list.get(iter);
                        break;
                    }
                    ++iter;
                }
                SetRequest setRequest = new SetRequest((EObject)this.profile, (EStructuralFeature)UMLPackage.eINSTANCE.getProfile_MetaclassReference(), (Object)added);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.profile);
                if (provider != null) {
                    ICommand editCommand = null;
                    editCommand = provider.getEditCommand((IEditCommandRequest)setRequest);
                    if (editCommand != null) {
                        addindCommand.add((IUndoableOperation)editCommand);
                    }
                }
            }
            this.customRequestAdapter.setNewElement((EObject)this.addedMetaclasses.get(i));
            ++i;
        }
        if (!addindCommand.isEmpty()) {
            return addindCommand;
        }
        return null;
    }
}

