/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.service;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.profile.custom.commands.DefineProfileCommand;
import org.eclipse.papyrus.uml.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileDefinitionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;

public class PreSaveProfileListener
implements ISaveEventListener {
    public void doSave(DoSaveEvent event) {
        Diagram diag = null;
        try {
            EObject profileEObject;
            IMultiDiagramEditor multidiag = event.getMultiDiagramEditor();
            if (multidiag instanceof PapyrusMultiDiagramEditor && ((diag = ((PapyrusMultiDiagramEditor)multidiag).getDiagram()) == null || diag.getElement() == null || !(diag.getElement() instanceof Profile))) {
                return;
            }
            String DEFINE_MSG = "In order to apply this profile, it had to be defined.\nWould you like to define it?";
            String PAPYRUS_QUESTION = "Papyrus question";
            boolean result = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)PAPYRUS_QUESTION, (String)DEFINE_MSG);
            if (!result) {
                return;
            }
            Collection editPartSet = null;
            DiagramEditPart diagramEditPart = null;
            Profile rootProfile = null;
            IMultiDiagramEditor diag1 = event.getMultiDiagramEditor();
            Object diagramView = diag1.getAdapter(IDiagramGraphicalViewer.class);
            if (diagramView instanceof DiagramGraphicalViewer) {
                editPartSet = ((DiagramGraphicalViewer)diagramView).getEditPartRegistry().values();
            }
            Iterator editPartIterator = editPartSet.iterator();
            while (editPartIterator.hasNext()) {
                diagramEditPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)editPartIterator.next()));
                if (diagramEditPart != null) break;
            }
            if ((profileEObject = ((Diagram)diagramEditPart.getModel()).getElement()) instanceof Profile) {
                rootProfile = (Profile)profileEObject;
            }
            Assert.isNotNull(rootProfile);
            diagramEditPart.getEditingDomain();
            ProfileDefinitionDialog dialog = new ProfileDefinitionDialog(new Shell(), rootProfile);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                PapyrusDefinitionAnnotation papyrusAnnotation = dialog.getPapyrusDefinitionAnnotation();
                TransactionalEditingDomain domain = diagramEditPart.getEditingDomain();
                DefineProfileCommand cmd = new DefineProfileCommand(domain, papyrusAnnotation, rootProfile, diagramEditPart.getViewer());
                try {
                    diagramEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)cmd));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs(DoSaveEvent event) {
    }
}

