/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageAsyncAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageName2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.CreationOnMessageEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.Message2ItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.MessageConnectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.MessageConnectionLineSegEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;

public class Message2EditPart
extends AbstractMessageEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4004;
    static final Font FFIGUREMESSAGEASYNCLABELFIGURE_FONT = new Font((Device)Display.getCurrent(), "SANS", 9, 0);

    public Message2EditPart(View view) {
        super(view);
    }

    protected void installRouter() {
        this.getConnectionFigure().setConnectionRouter(LifelineChildGraphicalNodeEditPolicy.messageRouter);
        this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_MOVE);
        this.refreshBendpoints();
    }

    protected void refreshRoutingStyles() {
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new Message2ItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationOnMessageEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new MessageConnectionEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeLinkLabelDisplayEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new MessageConnectionLineSegEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof MessageName2EditPart) {
            ((MessageName2EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureMessageAsyncLabelFigure());
            return true;
        }
        if (childEditPart instanceof MessageAsyncAppliedStereotypeEditPart) {
            ((MessageAsyncAppliedStereotypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getAppliedStereotypeLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof MessageName2EditPart) {
            return true;
        }
        return childEditPart instanceof MessageAsyncAppliedStereotypeEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new MessageAsync();
    }

    public MessageAsync getPrimaryShape() {
        return (MessageAsync)this.getFigure();
    }

    protected void handleNotificationEvent(Notification notification) {
        SequenceUtil.handleMessageSortChange((EditingDomain)this.getEditingDomain(), notification, (Message)this.resolveSemanticElement(), MessageSort.ASYNCH_CALL_LITERAL);
        super.handleNotificationEvent(notification);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().showSourceFeedback(request);
            this.getTarget().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().eraseSourceFeedback(request);
            this.getTarget().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    public class MessageAsync
    extends UMLEdgeFigure {
        private WrappingLabel fFigureMessageAsyncLabelFigure;
        private WrappingLabel fAppliedStereotypeLabel;

        public MessageAsync() {
            this.createContents();
            this.setTargetDecoration(this.createTargetDecoration());
        }

        protected void createContents() {
            super.createContents();
            this.fFigureMessageAsyncLabelFigure = new WrappingLabel();
            this.fFigureMessageAsyncLabelFigure.setText("");
            this.fFigureMessageAsyncLabelFigure.setForegroundColor(ColorConstants.black);
            this.fFigureMessageAsyncLabelFigure.setFont(FFIGUREMESSAGEASYNCLABELFIGURE_FONT);
            this.add((IFigure)this.fFigureMessageAsyncLabelFigure);
        }

        private RotatableDecoration createTargetDecoration() {
            PolylineDecoration df = new PolylineDecoration();
            df.setForegroundColor(ColorConstants.black);
            PointList pl = new PointList();
            pl.addPoint(Message2EditPart.this.getMapMode().DPtoLP(-2), Message2EditPart.this.getMapMode().DPtoLP(2));
            pl.addPoint(Message2EditPart.this.getMapMode().DPtoLP(0), Message2EditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(Message2EditPart.this.getMapMode().DPtoLP(-2), Message2EditPart.this.getMapMode().DPtoLP(-2));
            df.setTemplate(pl);
            df.setScale((double)Message2EditPart.this.getMapMode().DPtoLP(7), (double)Message2EditPart.this.getMapMode().DPtoLP(3));
            return df;
        }

        public WrappingLabel getFigureMessageAsyncLabelFigure() {
            return this.fFigureMessageAsyncLabelFigure;
        }

        public WrappingLabel getAppliedStereotypeLabel() {
            return super.getAppliedStereotypeLabel();
        }
    }
}

