/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers.MessageRouter;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class MessageConnectionLineSegEditPolicy
extends ConnectionBendpointEditPolicy {
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';

    public MessageConnectionLineSegEditPolicy() {
        super(LineMode.ORTHOGONAL_FREE);
    }

    public Command getCommand(Request request) {
        if (this.isHorizontal()) {
            return super.getCommand(request);
        }
        return null;
    }

    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        ConnectionNodeEditPart connectionPart;
        EObject message;
        if (this.getHost().getViewer() instanceof ScrollingGraphicalViewer && this.getHost().getViewer().getControl() instanceof FigureCanvas) {
            SelectInDiagramHelper.exposeLocation((FigureCanvas)((FigureCanvas)this.getHost().getViewer().getControl()), (Point)request.getLocation().getCopy());
        }
        if (this.getHost() instanceof ConnectionNodeEditPart && (message = (connectionPart = (ConnectionNodeEditPart)this.getHost()).resolveSemanticElement()) instanceof Message) {
            MessageEnd send = ((Message)message).getSendEvent();
            MessageEnd rcv = ((Message)message).getReceiveEvent();
            EditPart srcPart = connectionPart.getSource();
            LifelineEditPart srcLifelinePart = SequenceUtil.getParentLifelinePart(srcPart);
            EditPart tgtPart = connectionPart.getTarget();
            LifelineEditPart tgtLifelinePart = SequenceUtil.getParentLifelinePart(tgtPart);
            if (send instanceof OccurrenceSpecification && rcv instanceof OccurrenceSpecification && srcLifelinePart != null && tgtLifelinePart != null) {
                int y = request.getLocation().y;
                List<EditPart> empty = Collections.emptyList();
                Command srcCmd = OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand((OccurrenceSpecification)send, null, y, -1, srcLifelinePart, empty);
                Command tgtCmd = OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand((OccurrenceSpecification)rcv, null, y, -1, tgtLifelinePart, empty);
                CompoundCommand compoudCmd = new CompoundCommand(Messages.MoveMessageCommand_Label);
                Point oldLocation = SequenceUtil.getAbsoluteEdgeExtremity(connectionPart, true);
                if (oldLocation != null) {
                    int oldY = oldLocation.y;
                    if (oldY < y) {
                        compoudCmd.add(tgtCmd);
                        compoudCmd.add(srcCmd);
                    } else {
                        compoudCmd.add(srcCmd);
                        compoudCmd.add(tgtCmd);
                    }
                    return compoudCmd;
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof BendpointRequest && this.isHorizontal()) {
            super.showSourceFeedback(request);
        }
    }

    private boolean isHorizontal() {
        Connection connection = this.getConnection();
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(connection, connection.getPoints());
        return kind.equals((Object)MessageRouter.RouterKind.HORIZONTAL);
    }

    private static String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append(p.preciseX);
        s.append(',');
        s.append(p.preciseY);
        s.append(')');
        return s.toString();
    }
}

