/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CompartmentFigure;

public class RegionFigure
extends CompartmentFigure {
    private static final String REGION_COMPARTMENT = "regionCompartment";
    private static final List<String> COMPARTMENT = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(RegionFigure.REGION_COMPARTMENT);
        }
    };
    private boolean displayBottomBorder = false;
    private boolean displayRightBorder = false;

    public RegionFigure() {
        this(null);
        this.setBorder(null);
    }

    public RegionFigure(String tagLabel) {
        super(COMPARTMENT, tagLabel);
        ((AutomaticCompartmentLayoutManager)this.getLayoutManager()).setAddExtraHeight(false);
        this.setBorder(null);
    }

    public RectangleFigure getRegionCompartmentFigure() {
        return this.getCompartment(REGION_COMPARTMENT);
    }

    protected void paintBorder(Graphics graphics) {
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setForegroundColor(this.getForegroundColor());
        Rectangle rect = this.getBounds();
        if (this.displayRightBorder) {
            graphics.setLineStyle(2);
            graphics.setLineWidth(1);
            graphics.drawLine(rect.x + rect.width - 1, rect.y - 2, rect.x + rect.width - 1, rect.y - 2 + rect.height);
        }
        if (this.displayBottomBorder) {
            graphics.setLineStyle(2);
            graphics.setLineWidth(1);
            graphics.drawLine(rect.x - 2, rect.y + rect.height - 1, rect.x - 2 + rect.width, rect.y + rect.height - 1);
        }
    }

    public void setDisplayBottomBorder(boolean b) {
        this.displayBottomBorder = b;
    }

    public void setDisplayRightBorder(boolean b) {
        this.displayRightBorder = b;
    }
}

