/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionCreateElementCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RegionFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;

public class CustomRegionCompartmentCreationEditPolicy
extends CreationEditPolicy {
    IFigure sizeOnDropFeedback = null;
    String dropLocation = "R";

    public void eraseTargetFeedback(Request request) {
        if (this.sizeOnDropFeedback != null) {
            LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer").remove(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
    }

    public Command getCommand(Request request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        if (this.understandsRequest(request)) {
            if (request instanceof CreateUnspecifiedTypeRequest) {
                CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
                for (IElementType elementType : unspecReq.getElementTypes()) {
                    CreateRequest createRequest = unspecReq.getRequestForType(elementType);
                    if (!((IHintedType)elementType).getSemanticHint().equals(((IHintedType)UMLElementTypes.Region_3000).getSemanticHint())) continue;
                    View existingRegionCompartmentView = (View)this.getHost().getModel();
                    View existingRegionView = (View)existingRegionCompartmentView.eContainer();
                    SemanticAdapter adaptableForExistingRegionView = new SemanticAdapter(null, (Object)existingRegionView);
                    CustomRegionCreateElementCommand createNewRegion = new CustomRegionCreateElementCommand((IAdaptable)adaptableForExistingRegionView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)createNewRegion);
                    return new ICommandProxy(cc.reduce());
                }
            } else if (request instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
                Point mouseLocation = changeBoundsRequest.getLocation();
                DropObjectsRequest dropRequest = new DropObjectsRequest();
                dropRequest.setLocation(mouseLocation);
                ArrayList<View> list = new ArrayList<View>();
                for (EditPart ep : changeBoundsRequest.getEditParts()) {
                    if (!(ep instanceof RegionEditPart)) continue;
                    View regionToDrag = (View)ep.getModel();
                    list.add(regionToDrag);
                }
                dropRequest.setObjects(list);
                return this.getHost().getCommand((Request)dropRequest);
            }
            return super.getCommand(request);
        }
        return null;
    }

    protected IFigure getSizeOnDropFeedback() {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)((Shape)this.sizeOnDropFeedback));
            ((Shape)this.sizeOnDropFeedback).setLineStyle(4);
            this.sizeOnDropFeedback.setForegroundColor(ColorConstants.white);
            LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer").add(this.sizeOnDropFeedback);
        }
        return this.sizeOnDropFeedback;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            List elementTypes;
            CreateUnspecifiedTypeRequest createUnspecifiedTypeRequest = (CreateUnspecifiedTypeRequest)request;
            if (this.understandsRequest(request) && (elementTypes = createUnspecifiedTypeRequest.getElementTypes()).size() == 1 && ((IElementType)elementTypes.get(0) == UMLElementTypes.Pseudostate_16000 || (IElementType)elementTypes.get(0) == UMLElementTypes.Pseudostate_17000) && this.getHost() instanceof ShapeCompartmentEditPart) {
                return this.getHost().getParent().getParent().getParent();
            }
        }
        return super.getTargetEditPart(request);
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
            for (IElementType elementType : unspecReq.getElementTypes()) {
                if (!elementType.equals(UMLElementTypes.Region_3000)) continue;
                RegionFigure targetFig = ((RegionEditPart)this.getHost().getParent()).getPrimaryShape();
                Rectangle targetFigBounds = targetFig.getBounds().getCopy();
                targetFig.translateToAbsolute((Translatable)targetFigBounds);
                Point mouseLocation = unspecReq.getLocation();
                this.dropLocation = Zone.getZoneFromLocationInRectangleWithAbsoluteCoordinates(mouseLocation, targetFigBounds);
                if (Zone.isTop(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                } else if (Zone.isLeft(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                } else if (Zone.isRight(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                    targetFigBounds.translate(targetFigBounds.width, 0);
                } else if (Zone.isBottom(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                    targetFigBounds.translate(0, targetFigBounds.height);
                }
                this.getSizeOnDropFeedback().setBounds((Rectangle)new PrecisionRectangle(targetFigBounds));
            }
        }
    }
}

