/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDocumentProvider;
import org.eclipse.papyrus.uml.diagram.statemachine.preferences.DiagramPreferenceInitializer;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.ElementInitializers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.papyrus.uml.diagram.statemachine";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("org.eclipse.papyrus.uml.diagram.statemachine");
    private static UMLDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private UMLDocumentProvider documentProvider;
    private UMLBaseItemSemanticEditPolicy.LinkConstraints linkConstraints;
    private ElementInitializers initializers;
    private UMLOCLFactory oclFactory;

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return UMLDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static UMLDiagramEditorPlugin getInstance() {
        return instance;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)UMLDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new UMLItemProviderAdapterFactory());
        factories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, UMLDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public UMLDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new UMLDocumentProvider();
        }
        return this.documentProvider;
    }

    public ElementInitializers getElementInitializers() {
        return this.initializers;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public UMLBaseItemSemanticEditPolicy.LinkConstraints getLinkConstraints() {
        return this.linkConstraints;
    }

    public IPreferenceStore getPreferenceStore() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    public void setElementInitializers(ElementInitializers i) {
        this.initializers = i;
    }

    public UMLOCLFactory getUMLOCLFactory() {
        return this.oclFactory;
    }

    public void setUMLOCLFactory(UMLOCLFactory f) {
        this.oclFactory = f;
    }

    public void setLinkConstraints(UMLBaseItemSemanticEditPolicy.LinkConstraints lc) {
        this.linkConstraints = lc;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
        DiagramPreferenceInitializer diagramPreferenceInitializer = new DiagramPreferenceInitializer();
        diagramPreferenceInitializer.initializeDefaultPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        this.linkConstraints = null;
        this.initializers = null;
        this.oclFactory = null;
        instance = null;
        super.stop(context);
    }
}

