/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.category.PapyrusModelFromExistingDomainModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectDiagramKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRootElementPage;
import org.eclipse.ui.IWorkbench;

public class InitModelWizard
extends CreateModelWizard {
    private SelectRootElementPage selectRootElementPage;
    private boolean isInitFromExistingDomainModel;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IFile file = InitModelWizard.getSelectedFile(selection);
        this.isInitFromExistingDomainModel = InitModelWizard.isSupportedDomainModelFile(file);
        super.init(workbench, selection);
        this.selectRootElementPage = this.createSelectRootElementPage(file);
        if (this.isCreateFromExistingDomainModel()) {
            this.setWindowTitle(Messages.InitModelWizard_init_papyrus_diagram);
        }
    }

    protected SelectRootElementPage createSelectRootElementPage(IFile file) {
        if (!this.isCreateFromExistingDomainModel()) {
            return null;
        }
        return new SelectRootElementPage(file);
    }

    protected SelectDiagramKindPage createSelectDiagramKindPage() {
        if (this.isCreateFromExistingDomainModel()) {
            return new SelectDiagramKindPage(false, new SelectDiagramKindPage.CategoryProvider(){

                public String[] getCurrentCategories() {
                    return InitModelWizard.this.getDiagramCategoryIds();
                }
            }, SelectDiagramKindPage.DEFAULT_CREATION_COMMAND_REGISTRY);
        }
        return super.createSelectDiagramKindPage();
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        if (!this.isCreateFromExistingDomainModel()) {
            return super.createNewModelFilePage(selection);
        }
        return new NewDiagramForExistingModelPage(selection, String.valueOf(this.getDiagramFileName(InitModelWizard.getSelectedFile(selection))) + "." + this.getDiagramFileExtension(null), this.getDiagramFileExtension(null));
    }

    public void addPages() {
        super.addPages();
        this.addPageIfNotNull((IWizardPage)this.selectRootElementPage);
    }

    public static boolean isSupportedDomainModelFile(IFile file) {
        return file != null && "uml".equals(file.getFileExtension());
    }

    public static boolean isSupportedDomainModelFile(IStructuredSelection sselection) {
        IFile file = InitModelWizard.getSelectedFile(sselection);
        return InitModelWizard.isSupportedDomainModelFile(file);
    }

    protected void createPapyrusModels(DiResourceSet diResourceSet, IFile newFile) {
        if (this.isCreateFromExistingDomainModel()) {
            PapyrusModelFromExistingDomainModelCommand command = new PapyrusModelFromExistingDomainModelCommand((ModelSet)diResourceSet, newFile, this.getRoot());
            this.getCommandStack(diResourceSet).execute((Command)command);
        } else {
            super.createPapyrusModels(diResourceSet, newFile);
        }
    }

    protected void initDomainModel(DiResourceSet diResourceSet, IFile newFile, String diagramCategoryId) {
        if (!this.isCreateFromExistingDomainModel()) {
            super.initDomainModel(diResourceSet, newFile, diagramCategoryId);
        }
    }

    protected void initDiagrams(DiResourceSet diResourceSet, String categoryId) {
        this.initDiagrams(diResourceSet, this.getRoot(), categoryId);
    }

    protected boolean isCreateFromExistingDomainModel() {
        return this.isInitFromExistingDomainModel;
    }

    protected String getDiagramFileName(IFile domainModel) {
        return domainModel.getLocation().removeFileExtension().lastSegment();
    }

    protected String getDiagramFileExtension(String diagramCategoryId) {
        if (this.isCreateFromExistingDomainModel()) {
            return "di";
        }
        return super.getDiagramFileExtension(diagramCategoryId);
    }

    private static IFile getSelectedFile(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IFile) {
            return (IFile)selection.getFirstElement();
        }
        return null;
    }

    private EObject getRoot() {
        if (this.selectRootElementPage != null) {
            return this.selectRootElementPage.getModelElement();
        }
        return null;
    }

    protected class NewDiagramForExistingModelPage
    extends NewModelFilePage {
        private String myDiagramFileName;

        public NewDiagramForExistingModelPage(IStructuredSelection selection, String defaultFileName, String diagramExtension) {
            super(selection);
            this.myDiagramFileName = defaultFileName;
            this.setFileName(defaultFileName);
            this.setFileExtension(diagramExtension);
            this.setTitle(Messages.InitModelWizard_init_papyrus_model);
            this.setDescription(Messages.InitModelWizard_init_papyrus_model_desc);
        }

        protected boolean validatePage() {
            if (!super.validatePage()) {
                return false;
            }
            if (!this.myDiagramFileName.equals(this.getFileName())) {
                this.setErrorMessage(Messages.bind((String)Messages.InitModelWizard_diagram_name_is_different_from_domain_model, (Object)this.myDiagramFileName));
                return false;
            }
            return true;
        }
    }
}

