/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewPapyrusProjectWizard
extends CreateModelWizard {
    public static final String WIZARD_ID = "org.eclipse.papyrus.uml.diagram.wizards.1createproject";
    private WizardNewProjectCreationPage myNewProjectPage;
    private String initialProjectName;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.NewPapyrusProjectWizard_new_papyrus_project);
        this.myNewProjectPage = this.createNewProjectCreationPage();
    }

    protected WizardNewProjectCreationPage createNewProjectCreationPage() {
        WizardNewProjectCreationPage newProjectPage = new WizardNewProjectCreationPage("papyrusNewProjectPage");
        newProjectPage.setInitialProjectName(this.initialProjectName);
        newProjectPage.setTitle(Messages.NewPapyrusProjectWizard_papyrus_project);
        newProjectPage.setDescription(Messages.NewPapyrusProjectWizard_papyrus_project_desc);
        return newProjectPage;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myNewProjectPage);
        super.addPages();
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        return null;
    }

    public boolean performFinish() {
        IProject newProjectHandle;
        try {
            newProjectHandle = this.createNewProject();
        }
        catch (CoreException e) {
            Activator.log.error(Messages.NewPapyrusProjectWizard_exception_on_opening, (Throwable)e);
            return false;
        }
        if (newProjectHandle == null) {
            return false;
        }
        return super.performFinish();
    }

    protected IProject createNewProject() throws CoreException {
        IProject project = this.myNewProjectPage.getProjectHandle();
        URI projectLocationURI = null;
        if (!this.myNewProjectPage.useDefaults()) {
            projectLocationURI = this.myNewProjectPage.getLocationURI();
        }
        IProjectDescription projectDescription = null;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        if (!project.exists()) {
            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (projectLocationURI != null) {
                projectDescription.setLocationURI(projectLocationURI);
            }
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
        } else {
            projectDescription = project.getDescription();
            project.open((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
        }
        return project;
    }

    protected IFile createNewModelFile(String categoryId) {
        IPath newFilePath = this.myNewProjectPage.getProjectHandle().getFullPath().append(String.valueOf(NewModelFilePage.DEFAULT_NAME) + "." + this.getDiagramFileExtension(categoryId));
        return ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
    }

    public void setInitialProjectName(String initialProjectName) {
        this.initialProjectName = initialProjectName;
    }
}

