/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.kind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommandRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramKindContentProvider
implements IStructuredContentProvider {
    private final ICreationCommandRegistry creationCommandRegistry;

    public DiagramKindContentProvider(ICreationCommandRegistry creationCommandRegistry) {
        this.creationCommandRegistry = creationCommandRegistry;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            ArrayList<CreationCommandDescriptor> result = new ArrayList<CreationCommandDescriptor>();
            Object[] objectArray = (Object[])inputElement;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                if (next instanceof String) {
                    String diagramCategory = (String)next;
                    result.addAll(this.getCreationCommands(diagramCategory));
                }
                ++n2;
            }
            Collections.sort(result, new Comparator<CreationCommandDescriptor>(){

                @Override
                public int compare(CreationCommandDescriptor o1, CreationCommandDescriptor o2) {
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
            return result.toArray(new Object[result.size()]);
        }
        if (inputElement instanceof String) {
            String diagramCategory = (String)inputElement;
            List<CreationCommandDescriptor> result = this.getCreationCommands(diagramCategory);
            return result.toArray(new Object[result.size()]);
        }
        return null;
    }

    protected List<CreationCommandDescriptor> getCreationCommands(String diagramCategory) {
        ArrayList<CreationCommandDescriptor> result = new ArrayList<CreationCommandDescriptor>();
        for (CreationCommandDescriptor desc : this.getCreationCommandRegistry().getCommandDescriptors()) {
            if (diagramCategory == null || !diagramCategory.equals(desc.getLanguage())) continue;
            result.add(desc);
        }
        return result;
    }

    private ICreationCommandRegistry getCreationCommandRegistry() {
        return this.creationCommandRegistry;
    }
}

