/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.pastemanager.command;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusDuplicateWrapperCommand
extends AbstractTransactionalCommand {
    protected View container = null;
    protected ICommand duplicateEObjectsCommandOwner = null;
    protected List<Object> eObjectsToBeDuplicated = null;
    public static final String ADDITIONAL_DUPLICATED_ELEMENTS = "Additional_Duplicated_Elements";

    public PapyrusDuplicateWrapperCommand(TransactionalEditingDomain editingDomain, String label, List<Object> eObjectsToBeDuplicated, ICommandProxy subCommand, View container) {
        super(editingDomain, label, null);
        this.container = container;
        this.eObjectsToBeDuplicated = eObjectsToBeDuplicated;
        this.duplicateEObjectsCommandOwner = this.lookForDuplicateCommandOwner(subCommand);
    }

    public boolean canExecute() {
        for (EObject eObject : this.eObjectsToBeDuplicated) {
            if (eObject.eContainer() == null) {
                return true;
            }
            EReference reference = eObject.eContainmentFeature();
            if (reference != null && FeatureMapUtil.isMany((EObject)eObject.eContainer(), (EStructuralFeature)reference)) continue;
            return false;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.duplicateEObjectsCommandOwner.execute(progressMonitor, info);
        CommandResult result = this.duplicateEObjectsCommandOwner.getCommandResult();
        if (result.getReturnValue() instanceof List) {
            for (Object currentResult : (List)result.getReturnValue()) {
                if (!(currentResult instanceof Map)) continue;
                Map duplicatedObject = (Map)currentResult;
                for (Object object : duplicatedObject.values()) {
                    LayoutConstraint layoutConstraint;
                    if (!(object instanceof View)) continue;
                    View duplicatedView = (View)object;
                    if (object instanceof Shape && (layoutConstraint = ((Shape)object).getLayoutConstraint()) instanceof Bounds) {
                        ((Bounds)layoutConstraint).setX(((Bounds)layoutConstraint).getX() + 10);
                        ((Bounds)layoutConstraint).setY(((Bounds)layoutConstraint).getY() + 10);
                    }
                    if (duplicatedView.eContainer() != null || this.container == null) continue;
                    ViewUtil.insertChildView((View)this.container, (View)duplicatedView, (int)-1, (boolean)true);
                }
            }
        } else if (result.getReturnValue() instanceof Map) {
            IStatus status;
            Map duplicatedObject = (Map)result.getReturnValue();
            for (Object object : duplicatedObject.values()) {
                LayoutConstraint layoutConstraint;
                if (object instanceof Diagram) {
                    Diagram diagramView = (Diagram)object;
                    if (this.container == null || this.container.eResource() == null) continue;
                    this.container.eResource().getContents().add((Object)diagramView);
                    continue;
                }
                if (!(object instanceof View)) continue;
                View duplicatedView = (View)object;
                if (object instanceof Shape && (layoutConstraint = ((Shape)object).getLayoutConstraint()) instanceof Bounds) {
                    ((Bounds)layoutConstraint).setX(((Bounds)layoutConstraint).getX() + 10);
                    ((Bounds)layoutConstraint).setY(((Bounds)layoutConstraint).getY() + 10);
                }
                if (duplicatedView.eContainer() != null || this.container == null) continue;
                ViewUtil.insertChildView((View)this.container, (View)duplicatedView, (int)-1, (boolean)true);
            }
            ICommand externalObjectsDuplicateCommand = this.getExternalObjectsDuplicateCommand((Map)result.getReturnValue());
            if (externalObjectsDuplicateCommand != null && externalObjectsDuplicateCommand.canExecute() && !(status = externalObjectsDuplicateCommand.execute(progressMonitor, info)).isOK()) {
                return CommandResult.newErrorCommandResult((Throwable)status.getException());
            }
        }
        return result;
    }

    protected ICommand lookForDuplicateCommandOwner(ICommandProxy command) {
        return command.getICommand();
    }

    protected ICommand getExternalObjectsDuplicateCommand(Map duplicatedElementsMap) {
        CompositeCommand result = new CompositeCommand("Duplicate External Objects");
        HashSet duplicatedExternalElements = new HashSet();
        for (Object o : duplicatedElementsMap.keySet()) {
            if (!(o instanceof EObject)) continue;
            EObject object = (EObject)o;
            DuplicateElementsRequest request = new DuplicateElementsRequest(Collections.singletonList(object));
            request.setAllDuplicatedElementsMap(duplicatedElementsMap);
            request.setParameter(ADDITIONAL_DUPLICATED_ELEMENTS, duplicatedExternalElements);
            request.setParameter("Target_Owner", BusinessModelResolver.getInstance().getBusinessModel((Object)this.container));
            IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)object);
            ICommand command = service.getEditCommand((IEditCommandRequest)request);
            if (command == null) continue;
            result.add((IUndoableOperation)command);
        }
        return result.isEmpty() ? null : result.reduce();
    }
}

