/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.extensionpoints.library.FilteredRegisteredLibrariesSelectionDialog;
import org.eclipse.papyrus.uml.extensionpoints.library.RegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.profile.ui.dialogs.PackageImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.actions.AbstractPackageImportAction;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLibrariesFromRepositoryAction
extends AbstractPackageImportAction {
    @Override
    public ChangeCommand getCommand(EditingDomain domain) {
        if (this.command == null) {
            this.command = new ImportLibraryFromRepositoryCommand(domain);
        }
        return this.command;
    }

    protected void importLibraries(RegisteredLibrary[] librariesToImport) {
        ResourceSet resourceSet = Util.getResourceSet((EObject)this.selectedElement);
        int i = 0;
        while (i < librariesToImport.length) {
            RegisteredLibrary currentLibrary = librariesToImport[i];
            URI modelUri = currentLibrary.uri;
            Resource modelResource = resourceSet.getResource(modelUri, true);
            PackageImportTreeSelectionDialog eisd = new PackageImportTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
            int ret = eisd.open();
            if (ret == 0) {
                ArrayList result = eisd.getResult();
                for (Element element : result) {
                    PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
                    ei.setImportedPackage((Package)element);
                    this.getSelectedElement().getPackageImports().add((Object)ei);
                }
            }
            ++i;
        }
    }

    protected RegisteredLibrary[] getAvailableLibraries() {
        ArrayList<RegisteredLibrary> libraries = new ArrayList<RegisteredLibrary>();
        RegisteredLibrary[] allLibraries = RegisteredLibrary.getRegisteredLibraries();
        int i = 0;
        while (i < allLibraries.length) {
            RegisteredLibrary registeredLibrary = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)this.getSelectedElement());
            if (!importedPackageNames.contains(registeredLibrary.getName())) {
                libraries.add(registeredLibrary);
            }
            ++i;
        }
        return libraries.toArray(new RegisteredLibrary[libraries.size()]);
    }

    protected Collection<RegisteredLibrary> getImportedLibraries() {
        ArrayList<RegisteredLibrary> libraries = new ArrayList<RegisteredLibrary>();
        RegisteredLibrary[] allLibraries = RegisteredLibrary.getRegisteredLibraries();
        int i = 0;
        while (i < allLibraries.length) {
            RegisteredLibrary registeredLibrary = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)this.getSelectedElement());
            if (importedPackageNames.contains(registeredLibrary.getName())) {
                libraries.add(registeredLibrary);
            }
            ++i;
        }
        return libraries;
    }

    public class ImportLibraryFromRepositoryCommand
    extends ChangeCommand {
        public ImportLibraryFromRepositoryCommand(EditingDomain editingDomain) {
            super(editingDomain, new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Object[] allLibraries = RegisteredLibrary.getRegisteredLibraries();
                    FilteredRegisteredLibrariesSelectionDialog dialog = new FilteredRegisteredLibrariesSelectionDialog(shell, true, allLibraries, ImportLibrariesFromRepositoryAction.this.getImportedLibraries());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        List<Object> librariesToImport = Arrays.asList(dialog.getResult());
                        ImportLibrariesFromRepositoryAction.this.importLibraries(librariesToImport.toArray(new RegisteredLibrary[librariesToImport.size()]));
                    }
                }
            }, "Import Libraries", "Import Libraries from Repository");
        }

        public boolean canExecute() {
            return ImportLibrariesFromRepositoryAction.this.getSelectedElement() != null;
        }
    }
}

