/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementTreeViewer;
import org.eclipse.papyrus.uml.profile.tree.PropertyValueTreeViewer;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.ISectionComposite;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;

public abstract class DecoratedTreeComposite
extends Composite
implements ISectionComposite {
    protected CLabel label;
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected Button addButton;
    protected Button removeButton;
    protected Button upButton;
    protected Button downButton;
    protected MouseListener addButtonlistener;
    protected MouseListener removeButtonlistener;
    protected MouseListener upButtonlistener;
    protected MouseListener downButtonlistener;
    protected Listener treeListener;
    protected Element element;
    protected String name;

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public DecoratedTreeComposite(Composite parent, int style, String name, boolean isStereotypeTree) {
        super(parent, style);
        this.name = name;
        this.setLayout((Layout)new FormLayout());
        this.addButtonlistener = new AddButtonlistener();
        this.removeButtonlistener = new RemoveButtonlistener();
        this.upButtonlistener = new UpButtonlistener();
        this.downButtonlistener = new DownButtonlistener();
        this.treeViewer = isStereotypeTree ? new ProfileElementTreeViewer((Composite)this) : new PropertyValueTreeViewer((Composite)this);
    }

    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.removeButton = factory.createButton((Composite)this, "", 8);
        this.removeButton.setVisible(true);
        this.removeButton.setImage(ImageManager.IMG_DELETE);
        this.removeButton.setToolTipText("Delete selected element(s)");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -5);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addMouseListener(this.removeButtonlistener);
        this.addButton = factory.createButton((Composite)this, "", 8);
        this.addButton.setVisible(true);
        this.addButton.setImage(ImageManager.IMG_ADD);
        this.addButton.setToolTipText("Add a new element");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.removeButton, -5);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addMouseListener(this.addButtonlistener);
        this.upButton = factory.createButton((Composite)this, "", 8);
        this.upButton.setVisible(true);
        this.upButton.setImage(ImageManager.IMG_UP);
        this.upButton.setToolTipText("Up");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.addButton, -5);
        this.upButton.setLayoutData((Object)data);
        this.upButton.addMouseListener(this.upButtonlistener);
        this.downButton = factory.createButton((Composite)this, "", 8);
        this.downButton.setVisible(true);
        this.downButton.setImage(ImageManager.IMG_DOWN);
        this.downButton.setToolTipText("Down");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.upButton, -5);
        this.downButton.setLayoutData((Object)data);
        this.downButton.addMouseListener(this.downButtonlistener);
        this.label = factory.createCLabel((Composite)this, String.valueOf(this.name) + ":", 0);
        this.label.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)this.downButton, -35);
        data.top = new FormAttachment(0, 0);
        this.label.setLayoutData((Object)data);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayout((Layout)new FormLayout());
        this.tree.setVisible(true);
        this.treeListener = new EditItemListener();
        this.tree.addListener(8, this.treeListener);
        data = new FormData();
        data.top = new FormAttachment((Control)this.addButton, 4);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -4);
        this.tree.setLayoutData((Object)data);
        return this;
    }

    public void refresh() {
    }

    public CommandStack getCommandStack() {
        if (this.getActiveEditor() != null) {
            return (CommandStack)this.getActiveEditor().getAdapter(CommandStack.class);
        }
        return null;
    }

    public IEditorPart getActiveEditor() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public void addButtonPressed() {
    }

    public abstract void removeButtonPressed();

    public abstract void upButtonPressed();

    public abstract void downButtonPressed();

    public abstract void editItem(TreeItem var1);

    public void disposeListeners() {
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.removeMouseListener(this.addButtonlistener);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.removeMouseListener(this.removeButtonlistener);
        }
        if (this.upButton != null && !this.upButton.isDisposed()) {
            this.upButton.removeMouseListener(this.upButtonlistener);
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            this.downButton.removeMouseListener(this.downButtonlistener);
        }
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.removeListener(8, this.treeListener);
        }
    }

    private class AddButtonlistener
    implements MouseListener {
        private AddButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            DecoratedTreeComposite.this.addButtonPressed();
            DecoratedTreeComposite.this.refresh();
        }
    }

    private class DownButtonlistener
    implements MouseListener {
        private DownButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            TreeItem[] treeItems = DecoratedTreeComposite.this.tree.getSelection();
            DecoratedTreeComposite.this.downButtonPressed();
            DecoratedTreeComposite.this.refresh();
            DecoratedTreeComposite.this.tree.setSelection(treeItems);
        }
    }

    private class EditItemListener
    implements Listener {
        private EditItemListener() {
        }

        public void handleEvent(Event event) {
            if (DecoratedTreeComposite.this.tree.getSelection().length > 0) {
                TreeItem item = DecoratedTreeComposite.this.tree.getSelection()[0];
                DecoratedTreeComposite.this.editItem(item);
            }
        }
    }

    private class RemoveButtonlistener
    implements MouseListener {
        private RemoveButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            DecoratedTreeComposite.this.removeButtonPressed();
            DecoratedTreeComposite.this.refresh();
        }
    }

    private class UpButtonlistener
    implements MouseListener {
        private UpButtonlistener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            TreeItem[] treeItems = DecoratedTreeComposite.this.tree.getSelection();
            DecoratedTreeComposite.this.upButtonPressed();
            DecoratedTreeComposite.this.refresh();
            DecoratedTreeComposite.this.tree.setSelection(treeItems);
        }
    }
}

