/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.uml.properties.widgets.BodyEditor;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NaturalLanguageEditor
implements BodyEditor {
    private StringEditor editor;
    private final Set<Listener> changeListeners = new HashSet<Listener>();
    private String currentValue;

    public void createWidget(Composite parent, int style) {
        this.editor = new StringEditor(parent, style | 2 | 0x40){

            protected GridData getDefaultLayoutData() {
                GridData data = super.getDefaultLayoutData();
                data.grabExcessVerticalSpace = true;
                data.verticalAlignment = 4;
                return data;
            }
        };
        this.editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                Event event = new Event();
                NaturalLanguageEditor.this.currentValue = (String)NaturalLanguageEditor.this.editor.getValue();
                event.text = (String)NaturalLanguageEditor.this.editor.getValue();
                for (Listener listener : NaturalLanguageEditor.this.changeListeners) {
                    listener.handleEvent(event);
                }
            }
        });
        this.editor.layout();
    }

    public void setInput(String value) {
        this.currentValue = value;
        AbstractObservableValue observable = new AbstractObservableValue(){

            public Object getValueType() {
                return String.class;
            }

            protected Object doGetValue() {
                return NaturalLanguageEditor.this.currentValue;
            }

            protected void doSetValue(Object value) {
                if (value instanceof String) {
                    NaturalLanguageEditor.this.currentValue = (String)value;
                }
            }
        };
        this.editor.setModelObservable((IObservableValue)observable);
    }

    public void dispose() {
        this.editor.dispose();
        this.changeListeners.clear();
    }

    public void addChangeListener(Listener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Listener listener) {
        this.changeListeners.remove(listener);
    }

    public String getValue() {
        return this.currentValue;
    }

    public void setReadOnly(boolean readOnly) {
        this.editor.setReadOnly(readOnly);
    }

    public void setContext(ModelElement context) {
    }
}

