/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.listeners;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.internal.impl.ElementImpl;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PapyrusStereotypeListener
implements IPapyrusListener {
    public static final int APPLIED_STEREOTYPE = 20;
    public static final int UNAPPLIED_STEREOTYPE = 21;
    public static final int MODIFIED_STEREOTYPE = 22;

    public void notifyChanged(Notification notification) {
        int notificationValue;
        boolean isStereoApplication;
        if (!(notification.getFeature() instanceof EStructuralFeature)) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (!this.isBaseElementChanged(feature)) {
            Element baseElement;
            Object notifier = notification.getNotifier();
            if (notifier instanceof EObject && (baseElement = UMLUtil.getBaseElement((EObject)((EObject)notifier))) instanceof Element) {
                StereotypeCustomNotification newNotification = new StereotypeCustomNotification((ElementImpl)baseElement, 22, feature.getFeatureID(), null, notification.getNotifier());
                baseElement.eNotify((Notification)newNotification);
            }
            return;
        }
        if (1 != notification.getEventType()) {
            return;
        }
        Object value = notification.getNewValue();
        if (value instanceof Element) {
            isStereoApplication = ((Element)value).getStereotypeApplications().contains(notification.getNotifier());
            if (!isStereoApplication) {
                return;
            }
            notificationValue = 20;
        } else {
            value = notification.getOldValue();
            if (!(value instanceof Element)) {
                return;
            }
            isStereoApplication = ((Element)value).getStereotypeApplications().contains(notification.getNotifier());
            if (isStereoApplication) {
                return;
            }
            notificationValue = 21;
        }
        StereotypeCustomNotification newNotification = new StereotypeCustomNotification((ElementImpl)value, notificationValue, feature.getFeatureID(), null, notification.getNotifier());
        ((Element)value).eNotify((Notification)newNotification);
    }

    private boolean isBaseElementChanged(EStructuralFeature feature) {
        return feature.getName().startsWith("base_");
    }

    public class StereotypeCustomNotification
    extends ENotificationImpl {
        public StereotypeCustomNotification(ElementImpl notifier, int eventType, int featureID, Object oldValue, Object newValue) {
            super((InternalEObject)notifier, eventType, featureID, oldValue, newValue);
        }

        public boolean isTouch() {
            return false;
        }
    }
}

