/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IDecoration;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.Messages;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ModelExplorerDecorationAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class MoDiscoLabelProvider
extends CustomizableModelLabelProvider {
    private IPageIconsRegistry editorRegistry;
    private DecorationService decorationService;

    public MoDiscoLabelProvider() {
        super(Activator.getDefault().getCustomizationManager());
        try {
            this.decorationService = (DecorationService)EditorUtils.getServiceRegistry().getService(DecorationService.class);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public String getMarkerMessage(Object element) {
        return this.decorationService.getDecoration(element, false).getMessage();
    }

    public Image getImage(Object element) {
        ModelExplorerDecorationAdapter adapter = new ModelExplorerDecorationAdapter(null);
        if (element instanceof Diagram) {
            adapter.setDecoratorTarget(this.getEditorRegistry().getEditorIcon(element));
        } else {
            adapter.setDecoratorTarget(super.getImage(element));
        }
        if (element != null && (element instanceof EObject || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(EObject.class) != null)) {
            IDecoration decoration = this.decorationService.getDecoration(element, true);
            decoration.setDecorationImage(this.getImageDescriptor(decoration.getSeverity()));
            adapter.setDecoration(decoration.getDecorationImage(), Decoration.PreferedPosition.DEFAULT);
        }
        return adapter.getDecoratedImage();
    }

    private ImageDescriptor getImageDescriptor(int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor overlay = null;
        switch (severity) {
            case 2: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_ERROR");
                break;
            }
            case 1: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_WARNING");
            }
        }
        return overlay;
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof Diagram) {
            Diagram diagram = (Diagram)element;
            text = diagram.getName();
        } else if (element instanceof IAdaptable) {
            EObject obj = (EObject)((IAdaptable)element).getAdapter(EObject.class);
            if (obj instanceof InternalEObject && obj.eIsProxy()) {
                InternalEObject internal = (InternalEObject)obj;
                text = NLS.bind((String)Messages.MoDiscoLabelProvider_ProxyLabel, (Object)obj.getClass().getSimpleName(), (Object)internal.eProxyURI().trimFragment());
            } else {
                text = super.getText(element);
            }
        } else {
            text = super.getText(element);
        }
        return text;
    }
}

