/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.lifecycleevents.IEditorInputChangedListener;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.additional.AdditionalResourcesModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.ui.IRevealSemanticElement;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.providers.SemanticFromModelExplorer;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.CustomCommonViewer;
import org.eclipse.papyrus.views.modelexplorer.DecoratingLabelProviderWTooltips;
import org.eclipse.papyrus.views.modelexplorer.listener.DoubleClickListener;
import org.eclipse.papyrus.views.modelexplorer.matching.LinkItemMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.ModelElementItemMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.ReferencableMatchingItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExplorerView
extends CommonNavigator
implements IRevealSemanticElement,
IEditingDomainProvider {
    private ServicesRegistry serviceRegistry;
    private ISaveAndDirtyService saveAndDirtyService;
    private IUndoContext undoContext;
    private TransactionalEditingDomain editingDomain;
    private AtomicBoolean isRefreshing = new AtomicBoolean(false);
    private ISelectionListener pageSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ModelExplorerView.this.handleSelectionChangedFromDiagramEditor(part, selection);
        }
    };
    protected IEditorInputChangedListener editorInputChangedListener = new IEditorInputChangedListener(){

        public void editorInputChanged(FileEditorInput fileEditorInput) {
            ModelExplorerView.this.setPartName(fileEditorInput.getName());
        }

        public void isDirtyChanged() {
            ModelExplorerView.this.firePropertyChange(257);
        }
    };
    UndoActionHandler undoHandler;
    RedoActionHandler redoHandler;
    private IPropertySheetPage propertySheetPage = null;
    private final ResourceSetListener resourceSetListener = new ResourceSetListenerImpl(){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            super.resourceSetChanged(event);
            ModelExplorerView.this.handleResourceSetChanged(event);
        }
    };
    private Transaction lastTrans = null;

    public ModelExplorerView(IMultiDiagramEditor part) {
        if (part == null) {
            throw new IllegalArgumentException("A part should be provided.");
        }
        this.serviceRegistry = part.getServicesRegistry();
        if (this.serviceRegistry == null) {
            throw new IllegalArgumentException("The part should have a ServiceRegistry.");
        }
        this.setLinkingEnabled(true);
        try {
            this.saveAndDirtyService = (ISaveAndDirtyService)this.serviceRegistry.getService(ISaveAndDirtyService.class);
            this.undoContext = (IUndoContext)this.serviceRegistry.getService(IUndoContext.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void handleSelectionChangedFromDiagramEditor(IWorkbenchPart part, ISelection selection) {
        if (this.isLinkingEnabled() && part instanceof IEditorPart && selection instanceof IStructuredSelection) {
            Iterator selectionIterator = ((IStructuredSelection)selection).iterator();
            ArrayList<Object> semanticElementList = new ArrayList<Object>();
            while (selectionIterator.hasNext()) {
                Object semanticElement;
                Object currentSelection = selectionIterator.next();
                if (!(currentSelection instanceof IAdaptable) || (semanticElement = ((IAdaptable)currentSelection).getAdapter(EObject.class)) == null) continue;
                semanticElementList.add(semanticElement);
            }
            this.revealSemanticElement(semanticElementList);
        }
    }

    protected List<Object> searchPath(EObject eobject, List<Object> objects) {
        IPageMngr iPageMngr;
        SemanticFromModelExplorer semanticGetter = new SemanticFromModelExplorer();
        ArrayList<Object> path = new ArrayList<Object>();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        try {
            iPageMngr = ServiceUtils.getInstance().getIPageMngr((Object)this.serviceRegistry);
        }
        catch (ServiceException e) {
            return Collections.emptyList();
        }
        Object[] result = iPageMngr.allPages().toArray();
        List<Object> editors = Arrays.asList(result);
        for (Object o : objects) {
            if (!editors.contains(o) && o instanceof IAdaptable && eobject.equals(((IAdaptable)o).getAdapter(EObject.class))) {
                path.add(o);
                return path;
            }
            int i = 0;
            while (i < contentProvider.getChildren(o).length) {
                Object treeItem = contentProvider.getChildren(o)[i];
                List<Object> tmppath = new ArrayList();
                Object element = semanticGetter.getSemanticElement(treeItem);
                if (element != null) {
                    ArrayList<Object> childs;
                    if (element instanceof EReference) {
                        if (((EReference)element).isContainment() && !((EReference)element).isDerived()) {
                            childs = new ArrayList();
                            childs.add(treeItem);
                            tmppath = this.searchPath(eobject, childs);
                        }
                    } else if (element instanceof EObject) {
                        childs = new ArrayList<Object>();
                        childs.add(treeItem);
                        tmppath = this.searchPath(eobject, childs);
                    }
                }
                if (tmppath.size() > 0 && tmppath.get(tmppath.size() - 1) instanceof IAdaptable && eobject.equals(((IAdaptable)tmppath.get(tmppath.size() - 1)).getAdapter(EObject.class))) {
                    path.add(o);
                    path.addAll(tmppath);
                    return path;
                }
                ++i;
            }
        }
        return new ArrayList<Object>();
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        CustomCommonViewer viewer = new CustomCommonViewer(this.getViewSite().getId(), aParent, 770);
        NavigatorContentService contentService = new NavigatorContentService(this.getViewSite().getId());
        Set descriptors = contentService.findDescriptorsByTriggerPoint(this.getInitialInput(), false);
        for (Object descriptor : descriptors) {
            if (!(descriptor instanceof NavigatorContentDescriptor)) continue;
            try {
                ILabelProvider labelProvider = ((NavigatorContentDescriptor)descriptor).createLabelProvider();
                viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProviderWTooltips(labelProvider));
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            break;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        return viewer;
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setSorter(null);
        ((CustomCommonViewer)this.getCommonViewer()).getDropAdapter().setFeedbackEnabled(true);
        this.getCommonViewer().addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        Tree tree = this.getCommonViewer().getTree();
        Activator.getDefault().getCustomizationManager().installCustomPainter(tree);
    }

    public Control getControl() {
        return this.getCommonViewer().getControl();
    }

    public void init(IViewSite site, IMemento aMemento) throws PartInitException {
        super.init(site, aMemento);
        this.activate();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IWorkbenchPage page = site.getPage();
        page.addSelectionListener(this.pageSelectionListener);
    }

    private void handleResourceSetChanged(ResourceSetChangeEvent event) {
        Transaction curTrans = event.getTransaction();
        if (this.lastTrans != null && this.lastTrans.equals(curTrans)) {
            return;
        }
        this.lastTrans = curTrans;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ModelExplorerView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.isRefreshing.compareAndSet(false, true)) {
            if (!this.getCommonViewer().isBusy()) {
                this.getCommonViewer().refresh();
            }
            this.isRefreshing.set(false);
        }
    }

    protected Object getInitialInput() {
        if (this.serviceRegistry != null) {
            return this.serviceRegistry;
        }
        return super.getInitialInput();
    }

    private void activate() {
        try {
            this.editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.serviceRegistry);
            if (this.getCommonViewer() != null) {
                this.getCommonViewer().setInput((Object)this.serviceRegistry);
            }
            this.editingDomain.addResourceSetListener(this.resourceSetListener);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.saveAndDirtyService.addInputChangedListener(this.editorInputChangedListener);
        if (this.getCommonViewer() != null) {
            this.refresh();
        }
    }

    private void deactivate() {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("deactivate ModelExplorerView");
        }
        this.getSite().getPage().removeSelectionListener(this.pageSelectionListener);
        this.saveAndDirtyService.removeInputChangedListener(this.editorInputChangedListener);
        if (this.editingDomain != null) {
            this.editingDomain.removeResourceSetListener(this.resourceSetListener);
            this.editingDomain = null;
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.deactivate();
        this.saveAndDirtyService = null;
        this.undoContext = null;
        this.editingDomain = null;
        this.serviceRegistry = null;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.saveAndDirtyService == null;
    }

    private IPropertySheetPage getPropertySheetPage() {
        IMultiDiagramEditor multiDiagramEditor = EditorUtils.getMultiDiagramEditor();
        if (multiDiagramEditor != null) {
            if (this.propertySheetPage == null && multiDiagramEditor instanceof ITabbedPropertySheetPageContributor) {
                ITabbedPropertySheetPageContributor contributor = (ITabbedPropertySheetPageContributor)multiDiagramEditor;
                this.propertySheetPage = new TabbedPropertySheetPage(contributor);
            }
            return this.propertySheetPage;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        if (IUndoContext.class == adapter) {
            return this.undoContext;
        }
        if (ISaveablePart.class.equals((Object)adapter)) {
            return this.saveAndDirtyService;
        }
        if (ServicesRegistry.class == adapter) {
            return this.serviceRegistry;
        }
        return super.getAdapter(adapter);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void selectReveal(ISelection selection) {
        if (this.getCommonViewer() != null) {
            this.getCommonViewer().setSelection(selection, true);
        }
    }

    public void revealSemanticElement(List<?> elementList) {
        ModelExplorerView.reveal(elementList, this.getCommonViewer());
    }

    public static void reveal(Iterable<?> elementList, CommonViewer commonViewer) {
        ArrayList<ModelElementItemMatchingItem> matchingItemsToSelect = new ArrayList<ModelElementItemMatchingItem>();
        Iterable list = Iterables.transform((Iterable)Iterables.filter(elementList, EObject.class), (Function)new Function<Object, EObject>(){

            public EObject apply(Object from) {
                return (EObject)from;
            }
        });
        for (EObject currentEObject : list) {
            ResourceSet rs;
            matchingItemsToSelect.add(new ModelElementItemMatchingItem(currentEObject));
            if (commonViewer.getContentProvider() == null) continue;
            ArrayList<EObject> parents = new ArrayList<EObject>();
            EObject tmp = currentEObject.eContainer();
            while (tmp != null) {
                parents.add(tmp);
                tmp = tmp.eContainer();
            }
            Iterable reverseParents = Iterables.reverse(parents);
            Resource r = null;
            r = !parents.isEmpty() ? ((EObject)parents.get(parents.size() - 1)).eResource() : currentEObject.eResource();
            if (r != null && (rs = r.getResourceSet()) instanceof ModelSet && AdditionalResourcesModel.isAdditionalResource((ModelSet)((ModelSet)rs), (URI)r.getURI())) {
                commonViewer.expandToLevel((Object)new ReferencableMatchingItem(rs), 1);
                commonViewer.expandToLevel((Object)new ReferencableMatchingItem(r), 1);
            }
            EObject previousParent = null;
            for (EObject parent : reverseParents) {
                if (parent.eContainingFeature() != null && previousParent != null) {
                    commonViewer.expandToLevel((Object)new LinkItemMatchingItem(previousParent, parent.eContainmentFeature()), 1);
                }
                commonViewer.expandToLevel((Object)new ModelElementItemMatchingItem(parent), 1);
                previousParent = parent;
            }
            commonViewer.expandToLevel((Object)new LinkItemMatchingItem(currentEObject.eContainer(), currentEObject.eContainmentFeature()), 1);
        }
        ModelExplorerView.selectReveal((ISelection)new StructuredSelection(matchingItemsToSelect), (Viewer)commonViewer);
    }

    public static void selectReveal(ISelection structuredSelection, Viewer commonViewer) {
        commonViewer.setSelection(structuredSelection, true);
    }

    public static void reveal(ISelection selection, CommonViewer viewer) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            ModelExplorerView.reveal(Lists.newArrayList((Iterator)structured.iterator()), viewer);
        } else {
            viewer.setSelection(selection);
        }
    }
}

