/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ModelExplorerDecorationAdapter {
    protected Image decoratorTarget;
    protected ImageDescriptor decoration;
    protected int decorationPosition;
    private final Point size16 = new Point(16, 16);

    public ModelExplorerDecorationAdapter(Image baseImage) {
        this.decoratorTarget = baseImage;
    }

    public Image getDecoratedImage() {
        if (this.getDecoration() == null && this.getDecoratorTarget() != null) {
            return this.getDecoratorTarget();
        }
        if (this.getDecoration() == null && this.getDecoratorTarget() == null) {
            return null;
        }
        return this.getDecoratedImage(this.getDecoratorTarget(), this.getDecoration(), this.getDecorationPosition());
    }

    public ImageDescriptor getDecoration() {
        return this.decoration;
    }

    public Image getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public void setDecoration(ImageDescriptor decoration, int decorationPosition) {
        this.setDecoratedImage(this.getDecoratorTarget(), decoration, decorationPosition);
        this.decoration = decoration;
        this.decorationPosition = decorationPosition;
    }

    public void setDecoration(ImageDescriptor decoration) {
        this.setDecoratedImage(this.getDecoratorTarget(), decoration, this.getDecorationPosition());
        this.decoration = decoration;
    }

    public void setDecoratorTarget(Image decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public int getDecorationPosition() {
        return this.decorationPosition;
    }

    public void setDecorationPosition(int decorationPosition) {
        this.decorationPosition = decorationPosition;
    }

    public void setDecoratedImage(Image baseImage, ImageDescriptor decoration, int decorationPosition) {
        if (decoration == null || baseImage == null) {
            return;
        }
        DecorationOverlayIcon decoratedImage = null;
        String decoratedImageId = baseImage.toString().concat(String.valueOf(decoration.toString()) + decorationPosition);
        if (Activator.getDefault().getImageRegistry().get(decoratedImageId) == null) {
            switch (decorationPosition) {
                case 0: {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[0] = decoration;
                    decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, this.size16);
                    break;
                }
                case 1: {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[1] = decoration;
                    decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, this.size16);
                    break;
                }
                case 2: {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[2] = decoration;
                    decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, this.size16);
                    break;
                }
                case 3: {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[3] = decoration;
                    decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, this.size16);
                    break;
                }
                case 4: {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[4] = decoration;
                    decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, this.size16);
                    break;
                }
                default: {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[2] = decoration;
                    decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, this.size16);
                }
            }
            Activator.getDefault().getImageRegistry().put(decoratedImageId, (ImageDescriptor)decoratedImage);
        }
    }

    public Image getDecoratedImage(Image baseImage, ImageDescriptor decoration, int decorationPosition) {
        String decoratedImageId = baseImage.toString().concat(String.valueOf(decoration.toString()) + decorationPosition);
        if (Activator.getDefault().getImageRegistry().get(decoratedImageId) == null) {
            this.setDecoratedImage(baseImage, decoration, decorationPosition);
        }
        return Activator.getDefault().getImageRegistry().get(decoratedImageId);
    }

    public void setDecoratedImage(Image baseImage, ImageDescriptor[] decorationArray, Point imageSize) {
        DecorationOverlayIcon decoratedImage = null;
        String decoratedImageId = baseImage.toString().concat(decorationArray.toString());
        if (Activator.getDefault().getImageRegistry().get(decoratedImageId) == null) {
            decoratedImage = new DecorationOverlayIcon(baseImage, decorationArray, imageSize);
            Activator.getDefault().getImageRegistry().put(decoratedImageId, (ImageDescriptor)decoratedImage);
        }
    }

    public void setDecoration(ImageDescriptor decoration, Decoration.PreferedPosition position) {
        switch (position) {
            case NORTH_WEST: {
                this.setDecoration(decoration, 0);
                break;
            }
            case NORTH: {
                this.setDecoration(decoration, 1);
                break;
            }
            case NORTH_EAST: {
                this.setDecoration(decoration, 1);
                break;
            }
            case EAST: {
                this.setDecoration(decoration, 3);
                break;
            }
            case SOUTH_EAST: {
                this.setDecoration(decoration, 3);
                break;
            }
            case SOUTH: {
                this.setDecoration(decoration, 2);
                break;
            }
            case SOUTH_WEST: {
                this.setDecoration(decoration, 2);
                break;
            }
            case WEST: {
                this.setDecoration(decoration, 0);
                break;
            }
            case CENTER: {
                this.setDecoration(decoration, 4);
                break;
            }
            default: {
                this.setDecoration(decoration, 2);
            }
        }
    }
}

