/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandRegistry;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.commands.MoveOpenableCommand;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDropAdapterAssistant
extends org.eclipse.ui.navigator.CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object dropTarget) {
        Object targetElement = dropTarget;
        this.execute((Command)this.getDrop(targetElement));
        return null;
    }

    protected List<Command> getDropIntoCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject childElement, EReference eref) {
        ICommand command;
        ArrayList<Command> commandList = new ArrayList<Command>();
        MoveRequest moveRequest = new MoveRequest(targetOwner, childElement);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
        if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)moveRequest)) != null) {
            commandList.add((Command)new GMFtoEMFCommandWrapper(command));
        }
        return commandList;
    }

    private static ICreationCommandRegistry getCreationCommandRegistry() {
        return CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.core");
    }

    protected List<Command> getDropDiagramIntoCommand(TransactionalEditingDomain domain, EObject targetOwner, Diagram childElement) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        EReference eref = NotationPackage.eINSTANCE.getView_Element();
        if (eref != null) {
            String diagType = childElement.getType();
            ICreationCommand correctCommandDescription = null;
            for (CreationCommandDescriptor desc : CommonDropAdapterAssistant.getCreationCommandRegistry().getCommandDescriptors()) {
                if (desc.getCondition() != null && !desc.getCondition().create(targetOwner)) continue;
                try {
                    ICreationCommand cmd = desc.getCommand();
                    String type = cmd.getCreatedDiagramType();
                    if (diagType != null && !diagType.equals(type)) continue;
                    correctCommandDescription = cmd;
                    break;
                }
                catch (BackboneException e) {
                    Activator.log.error((Throwable)e);
                    commandList.add((Command)UnexecutableCommand.INSTANCE);
                    return commandList;
                }
            }
            if (correctCommandDescription != null && correctCommandDescription.isParentReassignable()) {
                Resource targetNotationResource;
                ICommand command;
                SetRequest setRequest = new SetRequest((EObject)childElement, (EStructuralFeature)eref, (Object)targetOwner);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)childElement);
                if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)setRequest)) != null && (targetNotationResource = this.getTargetNotationResource(targetOwner)) != null && !targetNotationResource.equals(childElement.eResource())) {
                    CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, "");
                    cc.add((IUndoableOperation)command);
                    cc.add((IUndoableOperation)new MoveOpenableCommand(domain, "", (EObject)childElement, targetNotationResource));
                    commandList.add((Command)new GMFtoEMFCommandWrapper((ICommand)cc));
                    return commandList;
                }
            }
        }
        commandList.add((Command)UnexecutableCommand.INSTANCE);
        return commandList;
    }

    protected Resource getTargetNotationResource(EObject targetOwner) {
        if (targetOwner.eResource() != null && targetOwner.eResource().getResourceSet() instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)targetOwner.eResource().getResourceSet();
            return modelSet.getAssociatedResource(targetOwner, "notation");
        }
        return null;
    }

    protected List<Command> getOrderChangeCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject objectLocation, EObject newElement, boolean before) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = targetOwner.eClass().getEAllStructuralFeatures();
        if (EcoreUtil.isAncestor((EObject)newElement, (EObject)targetOwner)) {
            return Collections.emptyList();
        }
        for (EStructuralFeature eStructuralFeature : featureList) {
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || !this.isSubClass(ref.getEType(), newElement.eClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
            ICommand command;
            ArrayList<EObject> tmp = new ArrayList<EObject>();
            if (targetOwner.eGet(eStructuralFeature) instanceof Collection) {
                tmp.addAll((Collection)targetOwner.eGet(eStructuralFeature));
                if (!newElement.equals(objectLocation)) {
                    tmp.remove(newElement);
                    int indexObject = tmp.indexOf(objectLocation);
                    if (before && indexObject != -1) {
                        tmp.add(tmp.indexOf(objectLocation), newElement);
                    } else if (!before && indexObject != -1) {
                        tmp.add(tmp.indexOf(objectLocation) + 1, newElement);
                    }
                }
            } else {
                tmp.add(newElement);
            }
            SetRequest setRequest = new SetRequest(targetOwner, eStructuralFeature, tmp);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
            if (provider == null || (command = provider.getEditCommand((IEditCommandRequest)setRequest)) == null) continue;
            commandList.add((Command)new GMFtoEMFCommandWrapper(command));
        }
        return commandList;
    }

    protected void execute(Command dropCommand) {
        this.getEditingDomain().getCommandStack().execute(dropCommand);
    }

    public CompoundCommand getDrop(Object target) {
        CommonDropAdapter dropAdapter = this.getCommonDropAdapter();
        List<Object> commandList = new ArrayList();
        switch (dropAdapter.getCurrentOperation()) {
            case 2: {
                if (dropAdapter.getCurrentLocation() == 1) {
                    if (!(target instanceof ModelElementItem)) break;
                    commandList = this.getOrderChangeCommand(target, true);
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 2) {
                    if (!(target instanceof ModelElementItem)) break;
                    commandList = this.getOrderChangeCommand(target, false);
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 3) {
                    if (target instanceof ModelElementItem) {
                        commandList = this.getDropIntoCommand(target, null);
                    }
                    if (!(target instanceof LinkItem)) break;
                    commandList = this.getDropIntoCommand(((LinkItem)target).getParent(), ((LinkItem)target).getReference());
                    break;
                }
                dropAdapter.getCurrentLocation();
            }
        }
        return new CompoundCommand(commandList);
    }

    public boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        CompoundCommand dropCommand = this.getDrop(target);
        if (dropCommand.canExecute()) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected List<Command> getDropIntoCommand(Object target, EReference eref) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject targetEObject = null;
        if (target instanceof EObject) {
            targetEObject = (EObject)target;
        }
        if (target instanceof IAdaptable) {
            targetEObject = (EObject)((IAdaptable)target).getAdapter(EObject.class);
        }
        if (targetEObject == null) {
            return result;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild = null;
                if (object instanceof IAdaptable) {
                    eObjectchild = (EObject)((IAdaptable)object).getAdapter(EObject.class);
                } else if (object instanceof EObject) {
                    eObjectchild = (EObject)object;
                }
                if (this.getEditors().contains(eObjectchild)) {
                    result.addAll(this.getDropDiagramIntoCommand(this.getEditingDomain(), targetEObject, (Diagram)eObjectchild));
                    continue;
                }
                if (eObjectchild == null) continue;
                result.addAll(this.getDropIntoCommand(this.getEditingDomain(), targetEObject, eObjectchild, eref));
            }
        }
        return result;
    }

    private List<Object> getEditors() {
        return EditorUtils.getIPageMngr().allPages();
    }

    protected List<Command> getOrderChangeCommand(Object target, boolean before) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject objectLocation = null;
        EObject objectOwner = null;
        if (target instanceof IAdaptable) {
            objectLocation = (EObject)((IAdaptable)target).getAdapter(EObject.class);
        }
        if (objectLocation == null) {
            return result;
        }
        objectOwner = objectLocation.eContainer();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild;
                if (!(object instanceof IAdaptable) || (eObjectchild = (EObject)((IAdaptable)object).getAdapter(EObject.class)) == null || objectOwner == null) continue;
                result.addAll(this.getOrderChangeCommand(this.getEditingDomain(), objectOwner, objectLocation, eObjectchild, before));
            }
        }
        return result;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return EditorUtils.getTransactionalEditingDomain();
    }

    protected IMultiDiagramEditor getMultiDiagramEditor() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editorPart;
        }
        return null;
    }
}

