/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.handler.DeleteCommandHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionStateSourceProvider
extends AbstractSourceProvider {
    public static final String DELETE_IN_MODEL_EXPLORER = "deleteInModelExplorer";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private final HashMap<String, String> currentState = new HashMap(2);
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private IPartService partService;
    private IPartListener partListener;
    private IWorkbenchPart currentActivatedPart = null;

    public ActionStateSourceProvider() {
        this.currentState.put(DELETE_IN_MODEL_EXPLORER, DISABLED);
        this.selectionListener = new SelectionListener();
        this.partListener = new PartListener();
    }

    public void dispose() {
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener(this.selectionListener);
        }
        if (this.partService != null) {
            this.partService.removePartListener(this.partListener);
        }
    }

    public Map<String, String> getCurrentState() {
        this.addSelectionListener();
        this.addPartListener();
        return this.currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{DELETE_IN_MODEL_EXPLORER};
    }

    protected void addSelectionListener() {
        if (this.selectionService == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    ActionStateSourceProvider.this.selectionService = (ISelectionService)workbench.getService(ISelectionService.class);
                    IWorkbenchWindow activeWorkbench = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbench != null) {
                        ActionStateSourceProvider.this.selectionService = activeWorkbench.getSelectionService();
                        if (ActionStateSourceProvider.this.selectionService != null) {
                            ActionStateSourceProvider.this.selectionService.addSelectionListener(ActionStateSourceProvider.this.selectionListener);
                        }
                    }
                }
            });
        }
    }

    protected void addPartListener() {
        if (this.partService == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    ActionStateSourceProvider.this.partService = (IPartService)workbench.getService(IPartService.class);
                    IWorkbenchWindow activeWorkbench = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbench != null) {
                        ActionStateSourceProvider.this.partService = activeWorkbench.getPartService();
                        if (ActionStateSourceProvider.this.partService != null) {
                            ActionStateSourceProvider.this.partService.addPartListener(ActionStateSourceProvider.this.partListener);
                        }
                    }
                }
            });
        }
    }

    protected boolean testDeleteFromModelExplorer() {
        DeleteCommandHandler handler = new DeleteCommandHandler();
        return this.isSelectionInModelExplorer() && handler.isEnabled();
    }

    protected void refreshDeleteAction() {
        String newState;
        String oldState = this.currentState.get(DELETE_IN_MODEL_EXPLORER);
        String string = newState = this.testDeleteFromModelExplorer() ? ENABLED : DISABLED;
        if (oldState != newState) {
            this.currentState.put(DELETE_IN_MODEL_EXPLORER, newState);
            this.fireSourceChanged(0, this.currentState);
        }
    }

    protected boolean isSelectionInModelExplorer() {
        return this.currentActivatedPart instanceof ModelExplorerPageBookView;
    }

    public class PartListener
    implements IPartListener {
        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            ActionStateSourceProvider.this.currentActivatedPart = part;
            ActionStateSourceProvider.this.refreshDeleteAction();
        }
    }

    public class SelectionListener
    implements ISelectionListener {
        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ActionStateSourceProvider.this.refreshDeleteAction();
        }
    }
}

