/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.environment.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.views.properties.environment.provider.CompositeWidgetTypeItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.EnvironmentItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.LayoutTypeItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.MiscClassItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.ModelElementFactoryDescriptorItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.NamespaceItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.PropertyEditorTypeItemProvider;
import org.eclipse.papyrus.views.properties.environment.provider.StandardWidgetTypeItemProvider;
import org.eclipse.papyrus.views.properties.environment.util.EnvironmentAdapterFactory;

public class EnvironmentItemProviderAdapterFactory
extends EnvironmentAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected EnvironmentItemProvider environmentItemProvider;
    protected PropertyEditorTypeItemProvider propertyEditorTypeItemProvider;
    protected CompositeWidgetTypeItemProvider compositeWidgetTypeItemProvider;
    protected LayoutTypeItemProvider layoutTypeItemProvider;
    protected ModelElementFactoryDescriptorItemProvider modelElementFactoryDescriptorItemProvider;
    protected StandardWidgetTypeItemProvider standardWidgetTypeItemProvider;
    protected NamespaceItemProvider namespaceItemProvider;
    protected MiscClassItemProvider miscClassItemProvider;

    public EnvironmentItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createEnvironmentAdapter() {
        if (this.environmentItemProvider == null) {
            this.environmentItemProvider = new EnvironmentItemProvider((AdapterFactory)this);
        }
        return this.environmentItemProvider;
    }

    public Adapter createPropertyEditorTypeAdapter() {
        if (this.propertyEditorTypeItemProvider == null) {
            this.propertyEditorTypeItemProvider = new PropertyEditorTypeItemProvider((AdapterFactory)this);
        }
        return this.propertyEditorTypeItemProvider;
    }

    public Adapter createCompositeWidgetTypeAdapter() {
        if (this.compositeWidgetTypeItemProvider == null) {
            this.compositeWidgetTypeItemProvider = new CompositeWidgetTypeItemProvider((AdapterFactory)this);
        }
        return this.compositeWidgetTypeItemProvider;
    }

    public Adapter createLayoutTypeAdapter() {
        if (this.layoutTypeItemProvider == null) {
            this.layoutTypeItemProvider = new LayoutTypeItemProvider((AdapterFactory)this);
        }
        return this.layoutTypeItemProvider;
    }

    public Adapter createModelElementFactoryDescriptorAdapter() {
        if (this.modelElementFactoryDescriptorItemProvider == null) {
            this.modelElementFactoryDescriptorItemProvider = new ModelElementFactoryDescriptorItemProvider((AdapterFactory)this);
        }
        return this.modelElementFactoryDescriptorItemProvider;
    }

    public Adapter createStandardWidgetTypeAdapter() {
        if (this.standardWidgetTypeItemProvider == null) {
            this.standardWidgetTypeItemProvider = new StandardWidgetTypeItemProvider((AdapterFactory)this);
        }
        return this.standardWidgetTypeItemProvider;
    }

    public Adapter createNamespaceAdapter() {
        if (this.namespaceItemProvider == null) {
            this.namespaceItemProvider = new NamespaceItemProvider((AdapterFactory)this);
        }
        return this.namespaceItemProvider;
    }

    public Adapter createMiscClassAdapter() {
        if (this.miscClassItemProvider == null) {
            this.miscClassItemProvider = new MiscClassItemProvider((AdapterFactory)this);
        }
        return this.miscClassItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.environmentItemProvider != null) {
            this.environmentItemProvider.dispose();
        }
        if (this.propertyEditorTypeItemProvider != null) {
            this.propertyEditorTypeItemProvider.dispose();
        }
        if (this.compositeWidgetTypeItemProvider != null) {
            this.compositeWidgetTypeItemProvider.dispose();
        }
        if (this.layoutTypeItemProvider != null) {
            this.layoutTypeItemProvider.dispose();
        }
        if (this.modelElementFactoryDescriptorItemProvider != null) {
            this.modelElementFactoryDescriptorItemProvider.dispose();
        }
        if (this.standardWidgetTypeItemProvider != null) {
            this.standardWidgetTypeItemProvider.dispose();
        }
        if (this.namespaceItemProvider != null) {
            this.namespaceItemProvider.dispose();
        }
        if (this.miscClassItemProvider != null) {
            this.miscClassItemProvider.dispose();
        }
    }
}

