/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.gmf.glue.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

public class CustomCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private CompletionProposal completionProposal;
    private int fReplacementOffset;
    private ContentAssistContext fContentAssistContext;
    private String fReplacementString;

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, ContentAssistContext contentAssistContext) {
        this.completionProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fReplacementOffset = replacementOffset;
        this.fReplacementString = replacementString;
        this.fContentAssistContext = contentAssistContext;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            int length = 0;
            length = offset != this.fReplacementOffset ? offset - this.fReplacementOffset : this.fContentAssistContext.getSelectedText().length();
            document.replace(this.fReplacementOffset, length, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isValidFor(IDocument document, int offset) {
        try {
            int length = offset - this.fReplacementOffset;
            return this.completionProposal.getDisplayString().toLowerCase().contains(document.get(this.fReplacementOffset, length).toLowerCase());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 0;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return this.completionProposal.getSelection(document);
    }

    public String getAdditionalProposalInfo() {
        return this.completionProposal.getAdditionalProposalInfo();
    }

    public String getDisplayString() {
        return this.completionProposal.getDisplayString();
    }

    public Image getImage() {
        return this.completionProposal.getImage();
    }

    public IContextInformation getContextInformation() {
        return this.completionProposal.getContextInformation();
    }
}

