/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.gmf.glue.edit.part;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.xtext.gmf.glue.Activator;
import org.eclipse.xtext.gmf.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXtextEMFReconciler;
import org.eclipse.xtext.gmf.glue.edit.part.PopupXtextEditorKeyListener;
import org.eclipse.xtext.gmf.glue.edit.part.StringUtil;
import org.eclipse.xtext.gmf.glue.partialEditing.CustomXtextSourceViewer;
import org.eclipse.xtext.gmf.glue.partialEditing.ISyntheticResourceProvider;
import org.eclipse.xtext.gmf.glue.partialEditing.OperationHistoryListener;
import org.eclipse.xtext.gmf.glue.partialEditing.PartialModelEditor;
import org.eclipse.xtext.gmf.glue.partialEditing.SourceViewerHandle;
import org.eclipse.xtext.gmf.glue.partialEditing.SourceViewerHandleFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class PopupXtextEditorHelper
implements IPopupEditorHelper {
    private static IGraphicalEditPart hostEditPart;
    private IEditorPart diagramEditor;
    private int editorOffset;
    private int initialEditorSize;
    private int initialDocumentSize;
    private Composite xtextEditorComposite;
    private final Injector xtextInjector;
    private XtextResource xtextResource;
    private String semanticElementFragment;
    private EObject semanticElement;
    private String textToEdit;
    public static String fileExtension;
    private IXtextEMFReconciler modelReconciler;
    private ISyntheticResourceProvider resourceProvider;
    private SourceViewerHandle sourceViewerHandle;
    private PartialModelEditor partialEditor;
    private Shell diagramShell;
    private OperationHistoryListener operationHistoryListener;
    private IXTextSemanticValidator semanticValidator;
    public static EObject context;
    public static boolean ignoreFocusLost;
    private PopupXtextEditorKeyListener keyListener;
    private Map<String, TextViewerAction> fGlobalActions = Maps.newHashMapWithExpectedSize((int)10);
    private List<String> fSelectionActions = Lists.newArrayListWithExpectedSize((int)3);

    static {
        ignoreFocusLost = false;
    }

    public static IGraphicalEditPart getHostEditPart() {
        return hostEditPart;
    }

    public SourceViewerHandle getSourceViewerHandle() {
        return this.sourceViewerHandle;
    }

    public PopupXtextEditorHelper(IGraphicalEditPart editPart, Injector xtextInjector, IXtextEMFReconciler modelReconciler, String textToEdit, String fileExtension, IXTextSemanticValidator semanticValidator) {
        hostEditPart = editPart;
        this.xtextInjector = xtextInjector;
        this.textToEdit = textToEdit;
        this.modelReconciler = modelReconciler;
        PopupXtextEditorHelper.fileExtension = fileExtension;
        this.semanticValidator = semanticValidator;
        ignoreFocusLost = false;
    }

    public void showEditor() {
        try {
            this.semanticElement = hostEditPart.resolveSemanticElement();
            if (this.semanticElement == null) {
                return;
            }
            context = this.semanticElement;
            Resource semanticResource = this.semanticElement.eResource();
            this.semanticElementFragment = semanticResource.getURIFragment(this.semanticElement);
            if (this.semanticElementFragment == null || "".equals(this.semanticElementFragment)) {
                return;
            }
            IDiagramEditDomain diagramEditDomain = hostEditPart.getDiagramEditDomain();
            this.diagramEditor = ((DiagramEditDomain)diagramEditDomain).getEditorPart();
            this.createXtextEditor(null);
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }

    public void closeEditor(boolean isReconcile) {
        if (this.sourceViewerHandle != null) {
            if (isReconcile && this.semanticValidator.validate()) {
                try {
                    XtextDocument xtextDocument = this.sourceViewerHandle.getDocument();
                    if (!this.isDocumentHasErrors((IXtextDocument)xtextDocument)) {
                        int documentGrowth = xtextDocument.getLength() - this.initialDocumentSize;
                        String newText = xtextDocument.get(this.editorOffset, this.initialEditorSize + documentGrowth);
                        this.xtextResource = this.partialEditor.createResource(newText);
                        if (this.xtextResource.getAllContents().hasNext()) {
                            this.modelReconciler.reconcile(this.semanticElement, (EObject)this.xtextResource.getAllContents().next());
                        }
                    }
                }
                catch (Exception exc) {
                    Activator.logError(exc);
                }
            }
            this.xtextEditorComposite.setVisible(false);
            this.xtextEditorComposite.dispose();
        }
        SourceViewerHandle.bindPartialModelEditorClass(null);
    }

    private void createXtextEditor(IEditorInput editorInput) throws Exception {
        this.diagramShell = this.diagramEditor.getSite().getShell();
        this.xtextEditorComposite = new Shell(16);
        this.xtextEditorComposite.setLayout((Layout)new FillLayout());
        this.resourceProvider = (ISyntheticResourceProvider)this.xtextInjector.getInstance(ISyntheticResourceProvider.class);
        SourceViewerHandleFactory factory = (SourceViewerHandleFactory)this.xtextInjector.getInstance(SourceViewerHandleFactory.class);
        this.sourceViewerHandle = factory.create(this.xtextEditorComposite, this.resourceProvider);
        this.partialEditor = this.sourceViewerHandle.createPartialEditor("", this.textToEdit, "", this.semanticElement, this.modelReconciler);
        this.registerKeyListener();
        this.setEditorBounds();
        this.initializeActions();
        this.installUndoRedoSupport((SourceViewer)this.sourceViewerHandle.getViewer());
        this.sourceViewerHandle.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                PopupXtextEditorHelper.this.checkedClose();
            }

            public void focusGained(FocusEvent e) {
                context = PopupXtextEditorHelper.this.semanticElement;
            }
        });
        this.xtextEditorComposite.setVisible(true);
        this.sourceViewerHandle.getViewer().showAnnotationsOverview(true);
        this.sourceViewerHandle.getViewer().getTextWidget().setFocus();
        this.sourceViewerHandle.getViewer().getTextWidget().append("");
    }

    private void checkedClose() {
        context = this.semanticElement;
        if (!this.keyListener.isContentAssistActive() && this.xtextEditorComposite.getDisplay().getActiveShell() != this.xtextEditorComposite) {
            if (!ignoreFocusLost) {
                this.closeEditor(true);
            } else {
                this.closeEditor(false);
            }
        }
    }

    private void registerKeyListener() {
        StyledText xtextTextWidget = this.sourceViewerHandle.getViewer().getTextWidget();
        CustomXtextSourceViewer viewer = (CustomXtextSourceViewer)this.sourceViewerHandle.getViewer();
        this.keyListener = new PopupXtextEditorKeyListener(this, (ContentAssistant)viewer.getContentAssistant());
        xtextTextWidget.addVerifyKeyListener((VerifyKeyListener)this.keyListener);
        xtextTextWidget.addKeyListener((KeyListener)this.keyListener);
    }

    private void setEditorBounds() {
        String editString = this.textToEdit;
        int[] numLinesNumColums = StringUtil.getNumLinesNumColumns(editString);
        int numLines = numLinesNumColums[0];
        int numColumns = numLinesNumColums[1];
        if (numLines < 5) {
            numLines = 5;
        }
        if (numColumns < 60) {
            numColumns = 60;
        }
        IFigure figure = hostEditPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        Point newCoord = this.diagramShell.getDisplay().map(hostEditPart.getViewer().getControl(), null, new Point(bounds.x, bounds.y));
        bounds.x = newCoord.x;
        bounds.y = newCoord.y;
        GC gc = new GC((Drawable)this.xtextEditorComposite);
        FontMetrics fm = gc.getFontMetrics();
        int width = numColumns * fm.getAverageCharWidth() + 40;
        int height = numLines * fm.getHeight();
        gc.dispose();
        org.eclipse.swt.graphics.Rectangle clientArea = this.xtextEditorComposite.getClientArea();
        this.xtextEditorComposite.setBounds(bounds.x, bounds.y, width, height += this.xtextEditorComposite.getSize().y - clientArea.height);
    }

    private boolean isDocumentHasErrors(IXtextDocument xtextDocument) {
        return (Boolean)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource state) throws Exception {
                IParseResult parseResult = state.getParseResult();
                if (state.getErrors().isEmpty() && parseResult != null && !parseResult.hasSyntaxErrors()) {
                    return false;
                }
                return true;
            }
        });
    }

    protected Status createErrorStatus(String message, TemplateException e) {
        return new Status(4, "org.eclipse.papyrus.property.editor.xtext", message, (Throwable)e);
    }

    protected void installUndoRedoSupport(SourceViewer viewer) {
        IDocumentUndoManager undoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)viewer.getDocument());
        IUndoContext context = undoManager.getUndoContext();
        CheckedOperationHistory operationHistory = CheckedOperationHistory.getInstance();
        this.operationHistoryListener = new OperationHistoryListener(context, new IUpdate(){

            public void update() {
                PopupXtextEditorHelper.this.updateAction(ITextEditorActionConstants.REDO);
                PopupXtextEditorHelper.this.updateAction(ITextEditorActionConstants.UNDO);
            }
        });
        operationHistory.addOperationHistoryListener((IOperationHistoryListener)this.operationHistoryListener);
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void uninstallUndoRedoSupport() {
        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        operationHistory.removeOperationHistoryListener((IOperationHistoryListener)this.operationHistoryListener);
        this.operationHistoryListener = null;
    }

    private void initializeActions() {
        final ArrayList handlerActivations = Lists.newArrayListWithExpectedSize((int)3);
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        ActiveShellExpression expression = new ActiveShellExpression(this.sourceViewerHandle.getViewer().getControl().getShell());
        this.diagramShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
            }
        });
        TextViewerAction action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 1);
        action.setText("UNDO");
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 2);
        action.setText("REDO");
        this.fGlobalActions.put(ITextEditorActionConstants.REDO, action);
        action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 3);
        action.setText("CUT");
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 4);
        action.setText("COPY");
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 5);
        action.setText("PASTE");
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 7);
        action.setText("SELECT_ALL");
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this.sourceViewerHandle.getViewer(), 13);
        action.setText("CONTENTASSIST_PROPOSALS");
        this.fGlobalActions.put("ContentAssistProposal", action);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        this.sourceViewerHandle.getViewer().getTextWidget().addFocusListener(new FocusListener((Expression)expression){
            private final /* synthetic */ Expression val$expression;
            {
                this.val$expression = expression;
            }

            public void focusLost(FocusEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
            }

            public void focusGained(FocusEvent e) {
                IAction action = (IAction)PopupXtextEditorHelper.this.fGlobalActions.get(ITextEditorActionConstants.REDO);
                handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new ActionHandler(action), this.val$expression));
                action = (IAction)PopupXtextEditorHelper.this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
                handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new ActionHandler(action), this.val$expression));
                action = (IAction)PopupXtextEditorHelper.this.fGlobalActions.get("ContentAssistProposal");
                handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)new ActionHandler(action), this.val$expression));
            }
        });
    }
}

