/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.compare.report.ui.action;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.ui.internal.wizard.SaveDeltaWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.compare.report.services.UmlElementService;
import org.eclipse.papyrus.compare.report.ui.common.GenerateAll;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAsHTMLWizard
extends SaveDeltaWizard {
    private static final String HTML_EXTENSION = "html";
    private static final String EMFDIFF_EXTENSION = "emfdiff";
    private WizardNewFileCreationPage myNewReportFileCreationPage;
    private IResource myFirstSelectedFile;
    private String myDefaultFileName;

    public ExportAsHTMLWizard() {
        super(null);
    }

    public void init(IWorkbench workbench, ComparisonSnapshot inputSnapshot) {
        super.init(workbench, inputSnapshot);
        DiffModel model = this.getDiffModel(inputSnapshot);
        Resource firstSelectedResource = this.getFirstSelectedResource(model);
        this.myFirstSelectedFile = ResourcesPlugin.getWorkspace().getRoot().findMember(firstSelectedResource.getURI().toPlatformString(true));
        this.myDefaultFileName = new UmlElementService().getFileName(model);
    }

    private DiffModel getDiffModel(ComparisonSnapshot inputSnapshot) {
        if (inputSnapshot instanceof ComparisonResourceSnapshot) {
            return ((ComparisonResourceSnapshot)inputSnapshot).getDiff();
        }
        EList diffModels = ((ComparisonResourceSetSnapshot)inputSnapshot).getDiffResourceSet().getDiffModels();
        if (!diffModels.isEmpty()) {
            return (DiffModel)diffModels.get(0);
        }
        return null;
    }

    private Resource getFirstSelectedResource(DiffModel diffModel) {
        EList leftRoots = diffModel.getLeftRoots();
        if (leftRoots.isEmpty()) {
            return null;
        }
        return ((EObject)leftRoots.get(0)).eResource();
    }

    public IStructuredSelection getSelection() {
        IStructuredSelection result = super.getSelection();
        if (result == null || result.isEmpty() && this.myFirstSelectedFile != null) {
            return new StructuredSelection((Object)this.myFirstSelectedFile);
        }
        return result;
    }

    public void addPages() {
        super.addPages();
        this.findNewDiffFilePage().setAllowExistingResources(true);
        this.findNewDiffFilePage().setFileExtension(EMFDIFF_EXTENSION);
        this.findNewDiffFilePage().setFileName(String.valueOf(this.getDefaultFileName()) + "." + EMFDIFF_EXTENSION);
        this.myNewReportFileCreationPage = new WizardNewFileCreationPage("newFilePage1", this.getSelection());
        this.myNewReportFileCreationPage.setFileName(String.valueOf(this.getDefaultFileName()) + "." + HTML_EXTENSION);
        this.myNewReportFileCreationPage.setAllowExistingResources(true);
        this.myNewReportFileCreationPage.setTitle("New HTML File");
        this.myNewReportFileCreationPage.setDescription("Create a new HTML file");
        this.myNewReportFileCreationPage.setFileExtension(HTML_EXTENSION);
        this.addPage((IWizardPage)this.myNewReportFileCreationPage);
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (!result) {
            return false;
        }
        this.myNewReportFileCreationPage.createNewFile();
        NullProgressMonitor monitor = new NullProgressMonitor();
        IResource targetFolder = this.getTargetFolder();
        File rawTargetFolder = this.getRawTargetFolder();
        GenerateAll generator = new GenerateAll(this.getNewDiffModelURI(), rawTargetFolder, this.getTemplateArguments());
        try {
            try {
                generator.doGenerate((IProgressMonitor)monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    targetFolder.refreshLocal(2, (IProgressMonitor)monitor);
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                targetFolder.refreshLocal(2, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String getDefaultFileName() {
        return this.myDefaultFileName;
    }

    private List<? extends Object> getTemplateArguments() {
        return Collections.singletonList(this.myNewReportFileCreationPage.getFileName());
    }

    private File getRawTargetFolder() {
        File targetFolder = null;
        IResource targetFolderResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.myNewReportFileCreationPage.getContainerFullPath());
        if (targetFolderResource.isLinked()) {
            targetFolder = targetFolderResource.getRawLocation().toFile();
        } else {
            IPath targetFolderPath = targetFolderResource.getLocation();
            if (targetFolderPath != null) {
                targetFolder = targetFolderPath.toFile();
            } else {
                WizardNewFileCreationPage saveDiffPage = this.findNewDiffFilePage();
                IPath filePath = saveDiffPage.getContainerFullPath().append(saveDiffPage.getFileName());
                IFile fileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                targetFolder = fileHandle.getRawLocation().toFile().getParentFile();
            }
        }
        return targetFolder;
    }

    private IResource getTargetFolder() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.myNewReportFileCreationPage.getContainerFullPath());
    }

    private WizardNewFileCreationPage findNewDiffFilePage() {
        String page = "newFilePage1";
        return (WizardNewFileCreationPage)this.getPage("newFilePage1");
    }

    private URI getNewDiffModelURI() {
        WizardNewFileCreationPage saveDiffPage = this.findNewDiffFilePage();
        IPath filePath = saveDiffPage.getContainerFullPath().append(saveDiffPage.getFileName());
        IFile fileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        return URI.createFileURI((String)fileHandle.getLocation().toOSString());
    }
}

