/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.common.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.engine.GenericMatchScopeProvider;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.emf.compare.common.Activator;
import org.eclipse.papyrus.infra.emf.compare.common.utils.ICompareViewerProvider;
import org.eclipse.papyrus.infra.emf.compare.common.utils.PapyrusModelCompareEditorInput;
import org.eclipse.papyrus.infra.emf.compare.ui.provider.EMFCompareLabelProvider;
import org.eclipse.papyrus.infra.emf.compare.ui.utils.ICustomizableEditor;
import org.eclipse.papyrus.infra.emf.compare.ui.utils.LabelProviderUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPapyrusCompareEditor
extends CompareEditor
implements ICustomizableEditor {
    private IOperationHistoryListener historyListener;
    private EMFCompareLabelProvider labelProvider;

    protected final void addUndoRedoListeners() {
        IOperationHistory operationHistory = this.getIOperationHistory();
        operationHistory.addOperationHistoryListener(this.getUndoRedoListener());
    }

    protected void removeUndoRedoListener() {
        IOperationHistory operationHistory = this.getIOperationHistory();
        operationHistory.removeOperationHistoryListener(this.getUndoRedoListener());
    }

    public EMFCompareLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = LabelProviderUtil.createLabelProvider();
        }
        return this.labelProvider;
    }

    protected Map<String, Object> getCompareOptions(IProgressMonitor monitor, EObject left, EObject right) {
        EMFCompareMap options = new EMFCompareMap();
        options.put("match.progress.monitor", monitor);
        options.put("match.scope.provider", new GenericMatchScopeProvider(left.eResource(), right.eResource()));
        options.put("match.ignore.id", Boolean.TRUE);
        options.put("match.ignore.xmi.id", Boolean.TRUE);
        return options;
    }

    public void setFocus() {
        this.refreshViewers();
        super.setFocus();
    }

    protected ComparisonSnapshot doContentCompare(final EObject left, final EObject right) {
        final ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    Map<String, Object> options = AbstractPapyrusCompareEditor.this.getCompareOptions(monitor, left, right);
                    MatchModel match = AbstractPapyrusCompareEditor.this.doMatch(monitor, left, right, options);
                    DiffModel diff = AbstractPapyrusCompareEditor.this.doDiff(match, options);
                    snapshot.setDiff(diff);
                    snapshot.setMatch(match);
                }
            });
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        catch (EMFCompareException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        return snapshot;
    }

    protected MatchModel doMatch(IProgressMonitor monitor, EObject left, EObject right, Map<String, Object> options) throws InterruptedException {
        return MatchService.doContentMatch((EObject)left, (EObject)right, options);
    }

    protected DiffModel doDiff(MatchModel match, Map<String, Object> options) {
        return DiffService.doDiff((MatchModel)match);
    }

    protected final ModelCompareEditorInput getCompareInput(EObject left, EObject right) {
        ComparisonSnapshot snapshot = this.doContentCompare(left, right);
        return this.getConfiguredModelCompareEditorInput(snapshot);
    }

    private final ModelCompareEditorInput getConfiguredModelCompareEditorInput(ComparisonSnapshot snapshot) {
        ModelCompareEditorInput input = this.createModelCompareEditorInput(snapshot);
        this.configureInput((PapyrusModelCompareEditorInput)input);
        return input;
    }

    protected ModelCompareEditorInput createModelCompareEditorInput(ComparisonSnapshot snapshot) {
        return new PapyrusModelCompareEditorInput(snapshot, (IEditorPart)this);
    }

    protected abstract void configureInput(PapyrusModelCompareEditorInput var1);

    protected void addListeners() {
    }

    public void refreshViewers() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ICompareViewerProvider) {
            ContentMergeViewer contentViewer = ((ICompareViewerProvider)input).getContentMergeViewer();
            ModelStructureMergeViewer structureViewer = ((ICompareViewerProvider)input).getStructureMergeViewer();
            if (contentViewer != null) {
                contentViewer.refresh();
            }
            if (structureViewer != null) {
                structureViewer.refresh();
            }
        }
    }

    protected IOperationHistoryListener getUndoRedoListener() {
        if (this.historyListener == null) {
            this.historyListener = new IOperationHistoryListener(){
                private OperationHistoryEvent lastEvent = null;

                public void historyNotification(OperationHistoryEvent event) {
                    int eventType = event.getEventType();
                    if ((eventType == 10 || eventType == 9) && this.lastEvent != event) {
                        this.lastEvent = event;
                        if (!event.getOperation().getLabel().equals("Create CompareEditor")) {
                            this.resetInput();
                        }
                    }
                }

                private void resetInput() {
                    AbstractPapyrusCompareEditor.this.resetInput();
                }
            };
        }
        return this.historyListener;
    }

    protected abstract IOperationHistory getIOperationHistory();

    protected abstract void resetInput();
}

