/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.common.editor;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.commands.NotifyingWorkspaceCommandStack;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.compare.common.Activator;
import org.eclipse.papyrus.infra.emf.compare.common.editor.AbstractPapyrusCompareEditor;
import org.eclipse.papyrus.infra.emf.compare.common.editor.listener.CloseEditorTriggerListener;
import org.eclipse.papyrus.infra.emf.compare.common.messages.Messages;
import org.eclipse.papyrus.infra.emf.compare.common.utils.EMFCompareUtils;
import org.eclipse.papyrus.infra.emf.compare.common.utils.PapyrusModelCompareEditorInput;
import org.eclipse.papyrus.infra.emf.compare.instance.papyrusemfcompareinstance.PapyrusEMFCompareInstance;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.PartInitException;

public class EMFCompareEditor
extends AbstractPapyrusCompareEditor
implements IReusableEditor,
ISaveablesSource,
IPropertyChangeListener,
ISaveablesLifecycleListener {
    protected ServicesRegistry servicesRegistry;
    private CloseEditorTriggerListener closeListener;
    protected PapyrusEMFCompareInstance rawModel;
    private CompareEditorInput input;
    private PartNameSynchronizer synchronizer;

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == IAction.class && event.getProperty() == CompareEditorInput.PROP_TITLE) {
            this.setPartName(EMFCompareUtils.getCompareEditorTitle((IEditorPart)this, this.rawModel));
        } else {
            super.propertyChange(event);
        }
    }

    public EMFCompareEditor(ServicesRegistry servicesRegistry, PapyrusEMFCompareInstance rawModel) {
        this.servicesRegistry = servicesRegistry;
        this.rawModel = rawModel;
        this.synchronizer = new PartNameSynchronizer(rawModel);
        this.input = this.getCompareInput(rawModel.getLeft(), rawModel.getRight());
        this.addListeners();
    }

    protected EMFCompareEditor() {
    }

    protected void addListeners() {
        this.addUndoRedoListeners();
        if (this.servicesRegistry != null) {
            TransactionalEditingDomain domain = null;
            try {
                domain = (TransactionalEditingDomain)this.servicesRegistry.getService(TransactionalEditingDomain.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            this.closeListener = new CloseEditorTriggerListener((EObject)this.rawModel, this.servicesRegistry);
            domain.addResourceSetListener((ResourceSetListener)this.closeListener);
        }
    }

    protected void removeListeners() {
        this.removeUndoRedoListener();
    }

    protected ISashWindowsContainer getISashWindowsContainer() {
        ISashWindowsContainer container = null;
        if (this.servicesRegistry != null) {
            try {
                container = ServiceUtils.getInstance().getISashWindowsContainer((Object)this.servicesRegistry);
            }
            catch (ServiceException e) {
                Activator.log.error("I can't get the  ISashWindowsContainer to add a listener on it", (Throwable)e);
            }
        }
        return container;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof CompareEditorInput) {
            super.init(site, input);
        } else {
            super.init(site, (IEditorInput)this.input);
        }
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    protected void configureInput(PapyrusModelCompareEditorInput input) {
    }

    protected IOperationHistory getIOperationHistory() {
        return ((NotifyingWorkspaceCommandStack)this.getEditingDomain().getCommandStack()).getOperationHistory();
    }

    protected void resetInput() {
        ModelStructureMergeViewer viewer = ((PapyrusModelCompareEditorInput)this.input).getStructureMergeViewer();
        PapyrusModelCompareEditorInput input = (PapyrusModelCompareEditorInput)this.getCompareInput(this.rawModel.getLeft(), this.rawModel.getRight());
        ModelCompareInput input2 = input.getpreparedModelCompareInput();
        viewer.setInput((Object)input2);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)this.getAdapter(TransactionalEditingDomain.class);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(TransactionalEditingDomain.class)) {
            TransactionalEditingDomain domain = null;
            try {
                domain = (TransactionalEditingDomain)this.servicesRegistry.getService(adapter);
            }
            catch (ServiceException e) {
                Activator.log.error(Messages.EMFCompareEditor_EditingDomainNotFound, (Throwable)e);
            }
            return domain;
        }
        return super.getAdapter(adapter);
    }

    public class PartNameSynchronizer {
        private PapyrusEMFCompareInstance compareInstance;
        private final Adapter tableNameListener = new Adapter(){

            public void notifyChanged(Notification notification) {
                EMFCompareEditor.this.setPartName(EMFCompareUtils.getCompareEditorTitle((IEditorPart)EMFCompareEditor.this, ((PartNameSynchronizer)PartNameSynchronizer.this).EMFCompareEditor.this.rawModel));
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        };

        public PartNameSynchronizer(PapyrusEMFCompareInstance compareInstance) {
            this.setCompare(compareInstance);
        }

        public void setCompare(PapyrusEMFCompareInstance compareInstance) {
            if (this.compareInstance != null) {
                compareInstance.getLeft().eAdapters().remove((Object)this.tableNameListener);
                compareInstance.getRight().eAdapters().remove((Object)this.tableNameListener);
            }
            this.compareInstance = compareInstance;
            compareInstance.getLeft().eAdapters().add((Object)this.tableNameListener);
            compareInstance.getRight().eAdapters().add((Object)this.tableNameListener);
        }
    }
}

