/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.common.editor.listener;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.compare.common.Activator;
import org.eclipse.papyrus.infra.emf.compare.common.messages.Messages;

public class CloseEditorTriggerListener
extends TriggerListener {
    private final EObject rawModel;
    private final ServicesRegistry registry;

    public CloseEditorTriggerListener(EObject rawModel, ServicesRegistry registry) {
        this.rawModel = rawModel;
        this.registry = registry;
    }

    protected Command trigger(final TransactionalEditingDomain domain, Notification notification) {
        PageRef ref;
        EObject pageId;
        Object notifier = notification.getNotifier();
        IPageMngr mngr = null;
        try {
            mngr = ServiceUtils.getInstance().getIPageMngr((Object)this.registry);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.CloseEditorTriggerListener_ICantFoundTheIPageManager, (Throwable)e);
        }
        final IPageMngr mngr2 = mngr;
        if (notifier instanceof PageRef && (pageId = (ref = (PageRef)notifier).getEmfPageIdentifier()) == this.rawModel) {
            CompoundCommand command = new CompoundCommand();
            RecordingCommand sashRemoveComd = new RecordingCommand(domain){

                protected void doExecute() {
                    mngr2.removePage((Object)CloseEditorTriggerListener.this.rawModel);
                }
            };
            EList tabls = this.rawModel.eResource().getContents();
            command.append((Command)sashRemoveComd);
            command.append((Command)new RemoveCommand((EditingDomain)domain, tabls, (Object)this.rawModel));
            RecordingCommand removeListener = new RecordingCommand(domain){

                protected void doExecute() {
                    domain.removeResourceSetListener((ResourceSetListener)CloseEditorTriggerListener.this);
                }
            };
            command.append((Command)removeListener);
            return command;
        }
        return null;
    }
}

