/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.common.factory;

import java.lang.reflect.Constructor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.compare.common.Activator;
import org.eclipse.papyrus.infra.emf.compare.common.utils.EMFCompareUtils;
import org.eclipse.papyrus.infra.emf.compare.instance.papyrusemfcompareinstance.PapyrusEMFCompareInstance;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEMFCompareEditorFactory
extends AbstractEditorFactory {
    public AbstractEMFCompareEditorFactory(Class<?> editorClass, String type) {
        super(editorClass, type);
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new CompareEditorModel(pageIdentifier, this.getServiceRegistry());
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        if (pageIdentifier instanceof PapyrusEMFCompareInstance) {
            return ((PapyrusEMFCompareInstance)pageIdentifier).getType().equals(this.getExpectedType());
        }
        return false;
    }

    private class CompareEditorModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private IEditorPart editor;
        private PapyrusEMFCompareInstance rawModel;

        public CompareEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry) {
            this.rawModel = (PapyrusEMFCompareInstance)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                Constructor c = AbstractEMFCompareEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, PapyrusEMFCompareInstance.class);
                this.editor = (IEditorPart)c.newInstance(this.servicesRegistry, this.rawModel);
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create CompareEditor", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = AbstractEMFCompareEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }

        public Image getTabIcon() {
            ImageDescriptor imageDescriptor = AbstractEMFCompareEditorFactory.this.getEditorDescriptor().getIcon();
            if (imageDescriptor == null) {
                return null;
            }
            return imageDescriptor.createImage();
        }

        public String getTabTitle() {
            return EMFCompareUtils.getCompareEditorTitle(this.editor, this.rawModel);
        }
    }
}

