/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.common.utils;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.compare.common.messages.Messages;
import org.eclipse.papyrus.infra.emf.compare.common.utils.ICompareViewerProvider;
import org.eclipse.papyrus.infra.emf.compare.ui.content.transactional.viewer.PapyrusTransactionalModelContentMergeViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.structural.viewer.PapyrusCustomizableParameterizedStructureMergeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;

public class PapyrusModelCompareEditorInput
extends ModelCompareEditorInput
implements ICompareViewerProvider {
    protected IEditorPart editor;

    public PapyrusModelCompareEditorInput(ComparisonSnapshot snapshot, IEditorPart editor) {
        super(snapshot);
        this.editor = editor;
    }

    public void initLabels(String leftLabel, Image leftImage, String rightLabel, Image rightImage) {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
        cc.setLeftImage(leftImage);
        cc.setRightImage(rightImage);
        this.setTitle(NLS.bind((String)Messages.PapyrusModelCompareEditorInput_CompareTitle, (Object)leftLabel, (Object)rightLabel));
    }

    protected ModelContentMergeViewer createMergeViewer(CompareViewerPane pane, CompareConfiguration config) {
        return new PapyrusTransactionalModelContentMergeViewer((Composite)pane, config, this.editor);
    }

    public Control createOutlineContents(Composite parent, int direction) {
        Splitter splitter = new Splitter(parent, direction);
        CompareViewerPane pane = new CompareViewerPane((Composite)splitter, 0);
        CompareConfiguration conf = this.getCompareConfiguration();
        this.structureMergeViewer = new PapyrusCustomizableParameterizedStructureMergeViewer((Composite)pane, this.getCompareConfiguration(), this.editor);
        pane.setContent((Control)this.structureMergeViewer.getTree());
        this.structureMergeViewer.setInput((Object)this.preparedInput);
        return splitter;
    }

    public void saveChanges(IProgressMonitor monitor) {
        super.saveChanges(monitor);
    }

    public ContentMergeViewer getContentMergeViewer() {
        return this.contentMergeViewer;
    }

    public ModelStructureMergeViewer getStructureMergeViewer() {
        return this.structureMergeViewer;
    }

    public ModelCompareInput getpreparedModelCompareInput() {
        this.prepareInput((IProgressMonitor)new NullProgressMonitor());
        return this.preparedInput;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain domain = null;
        if (this.editor instanceof IAdaptable) {
            domain = (TransactionalEditingDomain)this.editor.getAdapter(TransactionalEditingDomain.class);
        }
        return domain;
    }
}

