/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.check;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.AbstractCheck;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.compare.diff.check.IFeaturesCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesCheck
extends AbstractCheck
implements IFeaturesCheck {
    private final List<EStructuralFeature> ignoreAll;
    private final Map<EStructuralFeature, List<EObject>> ignoreSomeCase;

    public FeaturesCheck(IMatchManager manager, Map<String, Object> options) {
        super(manager);
        this.ignoreAll = options != null && options.containsKey("ignore_all_changes_on_features") ? (List)options.get("ignore_all_changes_on_features") : Collections.EMPTY_LIST;
        this.ignoreSomeCase = options != null && options.containsKey("ignore_changes_on_features_for") ? (Map)options.get("ignore_changes_on_features_for") : Collections.EMPTY_MAP;
    }

    public FeaturesCheck(IMatchManager manager) {
        this(manager, null);
    }

    @Override
    public boolean shouldBeIgnored(EStructuralFeature feature) {
        return this.ignoreAll.contains(feature);
    }

    @Override
    public boolean shouldBeIgnored(EStructuralFeature feature, EObject context) {
        if (this.shouldBeIgnored(feature)) {
            return true;
        }
        List<EObject> values = this.ignoreSomeCase.get(feature);
        if (values != null) {
            return values.contains(context);
        }
        return false;
    }
}

