/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.check;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.AttributesCheck;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.compare.diff.check.FeaturesCheck;

public class PapyrusAttributesCheck
extends AttributesCheck {
    private final FeaturesCheck checker;

    public PapyrusAttributesCheck(IMatchManager matchManager, FeaturesCheck featuresCheck) {
        super(matchManager);
        this.checker = featuresCheck;
    }

    protected boolean shouldBeIgnored(EAttribute attribute) {
        boolean shouldBeIgnored = super.shouldBeIgnored(attribute);
        return shouldBeIgnored || this.checker.shouldBeIgnored((EStructuralFeature)attribute);
    }

    protected boolean shouldBeIgnored(EAttribute attribute, EObject context) {
        return this.checker.shouldBeIgnored((EStructuralFeature)attribute, context);
    }

    public void checkAttributesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next) || this.shouldBeIgnored(next, mapping.getLeftElement())) continue;
            this.checkAttributeUpdates(root, mapping, next);
        }
    }

    public void checkAttributesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next) || this.shouldBeIgnored(next, mapping.getOriginElement())) continue;
            this.checkAttributeUpdates(root, mapping, next);
        }
    }
}

