/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.check;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.ReferencesCheck;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.compare.diff.check.FeaturesCheck;

public class PapyrusReferencesCheck
extends ReferencesCheck {
    private final FeaturesCheck checker;

    public PapyrusReferencesCheck(IMatchManager matchManager, FeaturesCheck checker) {
        super(matchManager);
        this.checker = checker;
    }

    protected boolean shouldBeIgnored(EReference reference) {
        boolean shouldBeIgnored = super.shouldBeIgnored(reference);
        return shouldBeIgnored || this.checker.shouldBeIgnored((EStructuralFeature)reference);
    }

    protected boolean shouldBeIgnored(EReference reference, EObject context) {
        return this.checker.shouldBeIgnored((EStructuralFeature)reference, context);
    }

    public void checkReferencesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (this.shouldBeIgnored(next, mapping.getLeftElement())) continue;
            if (!this.shouldBeIgnored(next)) {
                this.checkReferenceUpdates(root, mapping, next);
                continue;
            }
            if (!next.isContainment() || !next.isOrdered()) continue;
            this.checkContainmentReferenceOrderChange(root, mapping, next);
        }
    }

    public void checkReferencesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (this.shouldBeIgnored(next, mapping.getLeftElement())) continue;
            if (!this.shouldBeIgnored(next)) {
                this.checkReferenceUpdates(root, mapping, next);
                continue;
            }
            if (!next.isContainment() || !next.isOrdered()) continue;
            this.checkContainmentReferenceOrderChange(root, (Match2Elements)mapping, next);
        }
    }
}

