/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.command;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class CopyXMIIDCommand
extends AbstractCommand {
    private final EObject source;
    private final EObject target;
    private String initialID;

    public CopyXMIIDCommand(EObject source, EObject target) {
        this.source = source;
        this.target = target;
        this.initialID = null;
        this.setLabel("Copy XMI_ID command");
    }

    public void execute() {
        Resource sourceResource = this.source.eResource();
        Resource targetResource = this.target.eResource();
        if (sourceResource instanceof XMIResource && targetResource instanceof XMIResource && sourceResource != targetResource) {
            String xmi_id = EMFHelper.getXMIID((EObject)this.source);
            this.initialID = EMFHelper.getXMIID((EObject)this.target);
            ((XMIResource)this.target.eResource()).setID(this.target, xmi_id);
        }
    }

    public void redo() {
        this.execute();
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        Resource targetResource = this.target.eResource();
        if (targetResource instanceof XMIResource) {
            ((XMIResource)this.target.eResource()).setID(this.target, this.initialID);
        }
    }
}

