/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.MoveWithIndexRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveWithIndexCommand
extends MoveElementsCommand {
    public MoveWithIndexCommand(MoveRequest request) {
        super(request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int index = this.getIndex();
        if (index != -1) {
            for (EObject element : this.getElementsToMove().keySet()) {
                EReference feature = this.getTargetFeature(element);
                if (feature != null) {
                    if (FeatureMapUtil.isMany((EObject)this.getTargetContainer(), (EStructuralFeature)feature)) {
                        Object value;
                        if (this.shouldReorder()) {
                            this.attachRealPositionEAdapter(element, index);
                        }
                        if ((value = this.getTargetContainer().eGet((EStructuralFeature)feature)) instanceof List) {
                            List listValue = (List)value;
                            int indexMax = listValue.size() - 1;
                            if (indexMax < index) {
                                List values = (List)this.getTargetContainer().eGet((EStructuralFeature)feature);
                                values.add(element);
                                if (!this.shouldReorder()) continue;
                                this.reorderList(values);
                                continue;
                            }
                            ((List)value).add(index, element);
                            if (!this.shouldReorder()) continue;
                            this.reorderList((List)value);
                            continue;
                        }
                        ((Collection)this.getTargetContainer().eGet((EStructuralFeature)feature)).add(element);
                        if (!this.shouldReorder()) continue;
                        this.reorderList((List)((Collection)this.getTargetContainer().eGet((EStructuralFeature)feature)));
                        continue;
                    }
                    this.getTargetContainer().eSet((EStructuralFeature)feature, (Object)element);
                    continue;
                }
                return CommandResult.newErrorCommandResult((String)EMFTypeCoreMessages.moveElementsCommand_noTargetFeature);
            }
            return CommandResult.newOKCommandResult();
        }
        return super.doExecuteWithResult(monitor, info);
    }

    public boolean canExecute() {
        super.canExecute();
        return true;
    }

    protected int getIndex() {
        IEditCommandRequest req = this.getRequest();
        if (req instanceof MoveWithIndexRequest) {
            return ((MoveWithIndexRequest)req).getIndex();
        }
        return -1;
    }

    protected boolean shouldReorder() {
        IEditCommandRequest req = this.getRequest();
        boolean shouldReoder = false;
        if (req instanceof MoveWithIndexRequest) {
            shouldReoder = ((MoveWithIndexRequest)req).shouldReoder();
        }
        return shouldReoder;
    }

    private void attachRealPositionEAdapter(Object object, int expectedPosition) {
        if (object instanceof EObject) {
            ((EObject)object).eAdapters().add((Object)new PositionAdapter(expectedPosition));
        }
    }

    private <T> void reorderList(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        Collections.sort(newList, new EObjectComparator());
        int i = 0;
        while (i < list.size()) {
            int oldIndex = list.indexOf(newList.get(i));
            list.add(i, list.remove(oldIndex));
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EObjectComparator<T>
    implements Comparator<T> {
        private EObjectComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof EObject && o2 instanceof EObject) {
                int position1 = this.getWantedPosition((EObject)o1);
                int position2 = this.getWantedPosition((EObject)o2);
                if (position1 != -1 && position2 != -1) {
                    return position1 - position2;
                }
            }
            return 0;
        }

        private int getWantedPosition(EObject obj1) {
            Iterator adapters = obj1.eAdapters().iterator();
            int expectedIndex = -1;
            while (expectedIndex == -1 && adapters.hasNext()) {
                Adapter adapter = (Adapter)adapters.next();
                if (!(adapter instanceof PositionAdapter)) continue;
                expectedIndex = ((PositionAdapter)adapter).getExpectedIndex();
            }
            return expectedIndex;
        }
    }

    private static class PositionAdapter
    extends AdapterImpl {
        private final int expectedIndex;

        public PositionAdapter(int index) {
            this.expectedIndex = index;
        }

        public int getExpectedIndex() {
            return this.expectedIndex;
        }
    }
}

