/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.command;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.MoveWithIndexCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.MoveWithIndexRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class PapyrusMergeCommandProvider {
    public static PapyrusMergeCommandProvider INSTANCE = new PapyrusMergeCommandProvider();

    private PapyrusMergeCommandProvider() {
    }

    public Command getDestroyCommand(TransactionalEditingDomain domain, EObject element) {
        DestroyElementRequest request = new DestroyElementRequest(domain, element, false);
        return this.getCommand(element, (IEditCommandRequest)request);
    }

    public Command getMoveCommand(TransactionalEditingDomain domain, EObject elementToEdit, EObject targetContainer, EReference targetFeature, EObject elementToMove) {
        MoveRequest request = new MoveRequest(domain, targetContainer, targetFeature, elementToMove);
        return this.getCommand(elementToEdit, (IEditCommandRequest)request);
    }

    public Command getCommand(EObject elementToEdit, IEditCommandRequest request) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)elementToEdit);
        if (request instanceof MoveWithIndexRequest) {
            return new GMFtoEMFCommandWrapper((ICommand)new MoveWithIndexCommand((MoveRequest)request));
        }
        if (provider != null) {
            return new GMFtoEMFCommandWrapper(provider.getEditCommand(request));
        }
        return null;
    }

    public Command getDestroyReferenceCommand(TransactionalEditingDomain editingDomain, EObject container, EReference containingFeature, EObject referencedObject, boolean confirmationRequired) {
        DestroyReferenceRequest request = new DestroyReferenceRequest(editingDomain, container, containingFeature, referencedObject, confirmationRequired);
        return this.getCommand(container, (IEditCommandRequest)request);
    }

    public Command getSetCommand(TransactionalEditingDomain domain, EObject element, EStructuralFeature feature, Object value) {
        SetRequest request = new SetRequest(domain, element, feature, value);
        return this.getCommand(element, (IEditCommandRequest)request);
    }

    public Command getMoveWithIndexCommand(TransactionalEditingDomain domain, EObject elementToEdit, EObject targetContainer, EReference targetFeature, EObject elementToMove, int index, boolean reorder) {
        MoveWithIndexRequest request = new MoveWithIndexRequest(domain, targetContainer, targetFeature, elementToMove, index, reorder);
        return this.getCommand(elementToEdit, (IEditCommandRequest)request);
    }
}

