/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.merger;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.merge.service.MergeFactory;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.util.ClassUtils;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.merger.AbstractDefaultMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.util.CopyWithReferenceCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.merge.ITransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.service.TransactionalMergeFactory;
import org.eclipse.papyrus.infra.emf.compare.diff.service.TransactionalMergeService;
import org.eclipse.papyrus.infra.emf.compare.diff.utils.PapyrusCompareOptionsUtils;
import org.eclipse.papyrus.infra.emf.compare.diff.utils.PapyrusOptionsAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransactionalMerger
extends AbstractDefaultMerger
implements ITransactionalMerger {
    private static final String PROXY_SCHEME = "emfCompareProxy";
    private static List<DiffElement> mergedDiffs;
    private static MergedDiffsListener mergedDiffslistener;
    protected DiffElement diff;
    @Deprecated
    protected Resource leftResource;
    @Deprecated
    protected Resource rightResource;

    @Override
    public Command getApplyInOriginCommand(TransactionalEditingDomain domain) {
        PapyrusOptionsAdapter adapter = PapyrusCompareOptionsUtils.getPapyrusOptionsAdapter(this.diff);
        CompoundCommand cmd = new CompoundCommand(NLS.bind((String)"Apply in Origin Command for {0}", (Object)this.diff));
        if (adapter == null || adapter.canApplyInOrigin()) {
            cmd.append(this.getMergeRequiredDifferencesCommand(domain, true));
            cmd.append(this.getDoApplyInOriginCommand(domain));
            cmd.append(this.getPostProcessCommand(domain));
        } else {
            cmd.append((Command)UnexecutableCommand.INSTANCE);
        }
        return cmd;
    }

    @Override
    public Command getUndoInTargetCommand(TransactionalEditingDomain domain) {
        PapyrusOptionsAdapter adapter = PapyrusCompareOptionsUtils.getPapyrusOptionsAdapter(this.diff);
        CompoundCommand cmd = new CompoundCommand(NLS.bind((String)"Undo in Target Command for {0}", (Object)this.diff));
        if (adapter == null || adapter.canUndoInTarget()) {
            cmd.append(this.getMergeRequiredDifferencesCommand(domain, false));
            cmd.append(this.getDoUndoInTargetCommand(domain));
            cmd.append(this.getPostProcessCommand(domain));
        } else {
            cmd.append((Command)UnexecutableCommand.INSTANCE);
        }
        return cmd;
    }

    @Override
    public Command getDoApplyInOriginCommand(TransactionalEditingDomain domain) {
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command getDoUndoInTargetCommand(TransactionalEditingDomain domain) {
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command getMergeRequiredDifferencesCommand(TransactionalEditingDomain domain, boolean applyInOrigin) {
        CompoundCommand cmd = new CompoundCommand("Merge required differences");
        mergedDiffs = new ArrayList<DiffElement>();
        if (mergedDiffslistener == null) {
            mergedDiffslistener = new MergedDiffsListener();
            TransactionalMergeService.addMergeListener(mergedDiffslistener);
        }
        mergedDiffs.add(this.diff);
        for (DiffElement requiredDiff : this.getDependencies(applyInOrigin)) {
            if (requiredDiff.eContainer() == null || mergedDiffs.contains(requiredDiff)) continue;
            ITransactionalMerger merger = TransactionalMergeFactory.createMerger(requiredDiff);
            if (applyInOrigin) {
                cmd.append(merger.getApplyInOriginCommand(domain));
                continue;
            }
            cmd.append(merger.getUndoInTargetCommand(domain));
        }
        if (cmd.isEmpty()) {
            return IdentityCommand.INSTANCE;
        }
        return cmd;
    }

    @Override
    public Command getPostProcessCommand(TransactionalEditingDomain domain) {
        return new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, "Merge Required Differences", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DefaultTransactionalMerger.this.handleMutuallyDerivedReferences();
                if (DefaultTransactionalMerger.this.getDiffModel() != null) {
                    EMFCompareEObjectCopier copier = TransactionalMergeService.getCopier(DefaultTransactionalMerger.this.diff);
                    copier.copyXMIIDs();
                }
                DefaultTransactionalMerger.this.removeFromContainer(DefaultTransactionalMerger.this.diff);
                return null;
            }
        });
    }

    protected static TransactionalEditingDomain getTransactionalEditingDomain(DiffElement diff) {
        TransactionalEditingDomain domain;
        DiffElement diffElement = diff;
        TreeIterator iter = diff.eAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (!(current instanceof DiffElement) || current instanceof DiffGroup) continue;
            diffElement = (DiffElement)current;
            break;
        }
        EObject element = (EObject)ClassUtils.invokeMethod((Object)diffElement, (String)"getRightElement", (Object[])new Object[0]);
        if (element == null) {
            element = (EObject)ClassUtils.invokeMethod((Object)diffElement, (String)"getLeftElement", (Object[])new Object[0]);
        }
        if ((domain = TransactionUtil.getEditingDomain((EObject)element)) == null) {
            element = (EObject)ClassUtils.invokeMethod((Object)diffElement, (String)"getRightParent", (Object[])new Object[0]);
            if (element == null) {
                element = (EObject)ClassUtils.invokeMethod((Object)diffElement, (String)"getLeftParent", (Object[])new Object[0]);
            }
            domain = TransactionUtil.getEditingDomain((EObject)element);
        }
        Assert.isNotNull((Object)domain, (String)NLS.bind((String)"I didn't found the EditingDomain for {0}", (Object)diff));
        return domain;
    }

    @Override
    public boolean canApplyInOrigin() {
        return this.getApplyInOriginCommand(DefaultTransactionalMerger.getTransactionalEditingDomain(this.diff)).canExecute();
    }

    @Override
    public boolean canUndoInTarget() {
        return this.getUndoInTargetCommand(DefaultTransactionalMerger.getTransactionalEditingDomain(this.diff)).canExecute();
    }

    protected static void resetMergedDiffs() {
        mergedDiffs = null;
    }

    public static boolean isEMFCompareProxy(URI uri) {
        return uri.scheme() != null && uri.scheme().equals(PROXY_SCHEME);
    }

    public static boolean equalProxyURIs(URI uri1, URI uri2) {
        String stringValue1 = uri1.toString();
        String stringValue2 = uri2.toString();
        if (DefaultTransactionalMerger.isEMFCompareProxy(uri1)) {
            stringValue1 = stringValue1.substring(PROXY_SCHEME.length() + 2);
        }
        if (DefaultTransactionalMerger.isEMFCompareProxy(uri2)) {
            stringValue2 = stringValue2.substring(PROXY_SCHEME.length() + 2);
        }
        return stringValue1.equals(stringValue2);
    }

    @Override
    public void setDiffElement(DiffElement element) {
        this.diff = element;
    }

    protected void cleanDiffGroup(DiffGroup diffGroup) {
        EObject parent;
        if (diffGroup != null && diffGroup.getSubDiffElements().size() == 0 && (parent = diffGroup.eContainer()) instanceof DiffGroup) {
            EcoreUtil.remove((EObject)diffGroup);
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected AbstractTransactionalCommand getCopyWithReferenceCommand(EObject eObject) {
        return new CopyWithReferenceCommand(DefaultTransactionalMerger.getTransactionalEditingDomain(this.diff), TransactionalMergeService.getCopier(this.diff), eObject);
    }

    protected void ensureXMIIDCopied() {
        EMFCompareEObjectCopier copier = TransactionalMergeService.getCopier(this.diff);
        copier.copyXMIIDs();
    }

    protected DiffModel getDiffModel() {
        EObject container = this.diff.eContainer();
        while (container != null) {
            if (container instanceof DiffModel) {
                return (DiffModel)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    protected String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }

    protected void removeDanglingReferences(EObject deletedObject) {
    }

    protected void removeFromContainer(DiffElement diffElement) {
        EObject parent = diffElement.eContainer();
        EcoreUtil.remove((EObject)diffElement);
        this.removeDanglingReferences(parent);
        if (parent instanceof ConflictingDiffElement) {
            this.removeFromContainer((DiffElement)parent);
        }
        if (parent instanceof DiffGroup) {
            this.cleanDiffGroup((DiffGroup)parent);
        }
    }

    protected void setXMIID(EObject object, String id) {
        if (object != null && object.eResource() instanceof XMIResource) {
            ((XMIResource)object.eResource()).setID(object, id);
        }
    }

    protected void mergeRequiredDifferences(boolean applyInOrigin) {
        if (mergedDiffs == null) {
            mergedDiffs = new ArrayList<DiffElement>();
            if (mergedDiffslistener == null) {
                mergedDiffslistener = new MergedDiffsListener();
                MergeService.addMergeListener((IMergeListener)mergedDiffslistener);
            }
        }
        mergedDiffs.add(this.diff);
        for (DiffElement requiredDiff : this.getDependencies(applyInOrigin)) {
            if (requiredDiff.eContainer() == null || mergedDiffs.contains(requiredDiff)) continue;
            IMerger merger = MergeFactory.createMerger((DiffElement)requiredDiff);
            if (applyInOrigin) {
                merger.applyInOrigin();
                continue;
            }
            merger.undoInTarget();
        }
    }

    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        return new ArrayList<DiffElement>();
    }

    private void handleMutuallyDerivedReferences() {
        DiffElement toRemove = null;
        if (this.diff instanceof ReferenceChange) {
            EReference reference = ((ReferenceChange)this.diff).getReference();
            if (reference == EcorePackage.eINSTANCE.getEClass_ESuperTypes()) {
                EObject referenceType = null;
                if (this.diff instanceof ReferenceChangeLeftTarget) {
                    referenceType = ((ReferenceChangeLeftTarget)this.diff).getRightTarget();
                } else if (this.diff instanceof ReferenceChangeRightTarget) {
                    referenceType = ((ReferenceChangeRightTarget)this.diff).getLeftTarget();
                } else if (this.diff instanceof UpdateReference) {
                    referenceType = ((UpdateReference)this.diff).getLeftTarget();
                }
                for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                    if (siblingDiff instanceof ModelElementChangeLeftTarget) {
                        if (!(((ModelElementChangeLeftTarget)siblingDiff).getLeftElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeLeftTarget)siblingDiff).getLeftElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                    } else {
                        if (!(siblingDiff instanceof ModelElementChangeRightTarget) || !(((ModelElementChangeRightTarget)siblingDiff).getRightElement() instanceof EGenericType) || ((EGenericType)((ModelElementChangeRightTarget)siblingDiff).getRightElement()).getEClassifier() != referenceType) continue;
                        toRemove = siblingDiff;
                    }
                    break;
                }
            }
        } else if (this.diff instanceof ModelElementChangeLeftTarget && ((ModelElementChangeLeftTarget)this.diff).getLeftElement() instanceof EGenericType) {
            ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getLeftElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeLeftTarget) || ((ReferenceChangeLeftTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeLeftTarget)siblingDiff).getRightTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        } else if (this.diff instanceof ModelElementChangeRightTarget && ((ModelElementChangeRightTarget)this.diff).getRightElement() instanceof EGenericType) {
            ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
            EClassifier referenceType = ((EGenericType)theDiff.getRightElement()).getEClassifier();
            for (DiffElement siblingDiff : ((DiffGroup)this.diff.eContainer()).getSubDiffElements()) {
                if (!(siblingDiff instanceof ReferenceChangeRightTarget) || ((ReferenceChangeRightTarget)siblingDiff).getReference().getFeatureID() != 10 || ((ReferenceChangeRightTarget)siblingDiff).getLeftTarget() != referenceType) continue;
                toRemove = siblingDiff;
                break;
            }
        }
        if (toRemove != null) {
            this.removeFromContainer(toRemove);
        }
    }

    private class MergedDiffsListener
    implements IMergeListener {
        public void mergeDiffEnd(MergeEvent event) {
        }

        public void mergeDiffStart(MergeEvent event) {
        }

        public void mergeOperationEnd(MergeEvent event) {
            DefaultTransactionalMerger.resetMergedDiffs();
        }

        public void mergeOperationStart(MergeEvent event) {
        }
    }
}

