/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.merger;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.commands.AddToResourceCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.Activator;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.CopyXMIIDCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.PapyrusMergeCommandProvider;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.merger.DefaultTransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.util.PapyrusEFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementChangeLeftTargetTransactionalMerger
extends DefaultTransactionalMerger {
    @Override
    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        if (!applyInOrigin) {
            return this.diff.getRequires();
        }
        return super.getDependencies(applyInOrigin);
    }

    @Override
    public Command getDoApplyInOriginCommand(TransactionalEditingDomain domain) {
        ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
        EObject element = theDiff.getLeftElement();
        return PapyrusMergeCommandProvider.INSTANCE.getDestroyCommand(domain, element);
    }

    @Override
    public Command getDoUndoInTargetCommand(TransactionalEditingDomain domain) {
        CompoundCommand cmd = new CompoundCommand("Command CModelElementChangeLeftTargetMerger#getDoUndoInTargetCommand");
        ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
        final EObject origin = theDiff.getRightParent();
        final EObject element = theDiff.getLeftElement();
        AbstractTransactionalCommand copyCommand = this.getCopyWithReferenceCommand(element);
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)copyCommand));
        final EObject newOne = (EObject)copyCommand.getCommandResult().getReturnValue();
        final EReference ref = element.eContainmentFeature();
        if (ref != null) {
            try {
                Object containmentRefVal;
                int elementIndex = -1;
                if (ref.isMany() && (containmentRefVal = element.eContainer().eGet((EStructuralFeature)ref)) instanceof List) {
                    List listVal = (List)containmentRefVal;
                    elementIndex = listVal.indexOf(element);
                }
                cmd.append(PapyrusEFactory.getEAddCommand(domain, origin, ref.getName(), newOne, elementIndex, true));
                cmd.append((Command)new CopyXMIIDCommand(element, newOne));
            }
            catch (FactoryException e) {
                Activator.log.error((Throwable)e);
            }
        } else if (origin == null && this.getDiffModel().getRightRoots().size() > 0) {
            cmd.append((Command)new AddToResourceCommand(((EObject)this.getDiffModel().getRightRoots().get(0)).eResource(), newOne));
        } else if (origin != null) {
            cmd.append((Command)new AddToResourceCommand(origin.eResource(), newOne));
        }
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DiffModel diffModel = ModelElementChangeLeftTargetTransactionalMerger.this.getDiffModel();
                if (diffModel != null) {
                    TreeIterator siblings = diffModel.eAllContents();
                    while (siblings.hasNext()) {
                        ReferenceChangeLeftTarget link;
                        Object op = siblings.next();
                        if (op instanceof ReferenceChangeLeftTarget) {
                            link = (ReferenceChangeLeftTarget)op;
                            if (link.getRightTarget() == null || link.getRightTarget() != element) continue;
                            link.setLeftTarget(newOne);
                            continue;
                        }
                        if (!(op instanceof ReferenceOrderChange) || (link = (ReferenceOrderChange)op).getRightElement() != origin || link.getReference() != ref) continue;
                        ListIterator targetIterator = link.getRightTarget().listIterator();
                        boolean replaced = false;
                        while (!replaced && targetIterator.hasNext()) {
                            EObject target = (EObject)targetIterator.next();
                            if (!target.eIsProxy() || !ModelElementChangeLeftTargetTransactionalMerger.equalProxyURIs(((InternalEObject)target).eProxyURI(), EcoreUtil.getURI((EObject)element))) continue;
                            targetIterator.set(newOne);
                            replaced = true;
                        }
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        }));
        return cmd;
    }
}

