/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.merger;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.commands.AddToResourceCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.Activator;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.CopyXMIIDCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.PapyrusMergeCommandProvider;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.merger.DefaultTransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.util.PapyrusEFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementChangeRightTargetTransactionalMerger
extends DefaultTransactionalMerger {
    @Override
    public boolean canUndoInTarget() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        boolean isRightElementNotNull = theDiff.getRightElement() != null;
        return isRightElementNotNull;
    }

    @Override
    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        if (applyInOrigin) {
            return this.diff.getRequires();
        }
        return super.getDependencies(applyInOrigin);
    }

    @Override
    public Command getDoApplyInOriginCommand(TransactionalEditingDomain domain) {
        CompoundCommand cmd = new CompoundCommand("Command CModelElementChangeRightTargetMerger#getDoApplyInOriginCommand");
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        final EObject origin = theDiff.getLeftParent();
        final EObject element = theDiff.getRightElement();
        AbstractTransactionalCommand copyCommand = this.getCopyWithReferenceCommand(element);
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)copyCommand));
        final EObject newOne = (EObject)copyCommand.getCommandResult().getReturnValue();
        final EReference ref = element.eContainmentFeature();
        if (ref != null) {
            try {
                Object containmentRefVal;
                int expectedIndex = -1;
                if (ref.isMany() && (containmentRefVal = element.eContainer().eGet((EStructuralFeature)ref)) instanceof List) {
                    List listVal = (List)containmentRefVal;
                    expectedIndex = listVal.indexOf(element);
                }
                cmd.append(PapyrusEFactory.getEAddCommand(domain, origin, ref.getName(), newOne, expectedIndex, true));
                cmd.append((Command)new CopyXMIIDCommand(element, newOne));
            }
            catch (FactoryException e) {
                Activator.log.error((Throwable)e);
            }
        } else if (origin == null && this.getDiffModel().getLeftRoots().size() > 0) {
            cmd.append((Command)new AddToResourceCommand(((EObject)this.getDiffModel().getLeftRoots().get(0)).eResource(), newOne));
        } else if (origin != null) {
            cmd.append((Command)new AddToResourceCommand(origin.eResource(), newOne));
        }
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DiffModel diffModel = ModelElementChangeRightTargetTransactionalMerger.this.getDiffModel();
                if (diffModel != null) {
                    TreeIterator siblings = diffModel.eAllContents();
                    while (siblings.hasNext()) {
                        ReferenceChangeRightTarget link;
                        DiffElement op = (DiffElement)siblings.next();
                        if (op instanceof ReferenceChangeRightTarget) {
                            link = (ReferenceChangeRightTarget)op;
                            if (link.getLeftTarget() == null || link.getLeftTarget() != element) continue;
                            link.setRightTarget(newOne);
                            continue;
                        }
                        if (!(op instanceof ReferenceOrderChange) || (link = (ReferenceOrderChange)op).getLeftElement() != origin || link.getReference() != ref) continue;
                        ListIterator targetIterator = link.getLeftTarget().listIterator();
                        boolean replaced = false;
                        while (!replaced && targetIterator.hasNext()) {
                            EObject target = (EObject)targetIterator.next();
                            if (!target.eIsProxy() || !ModelElementChangeRightTargetTransactionalMerger.equalProxyURIs(((InternalEObject)target).eProxyURI(), EcoreUtil.getURI((EObject)element))) continue;
                            targetIterator.set(newOne);
                            replaced = true;
                        }
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        }));
        return cmd;
    }

    @Override
    public Command getDoUndoInTargetCommand(TransactionalEditingDomain domain) {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        EObject element = theDiff.getRightElement();
        return PapyrusMergeCommandProvider.INSTANCE.getDestroyCommand(domain, element);
    }
}

