/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.merger;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.PapyrusMergeCommandProvider;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.merger.DefaultTransactionalMerger;

public class MoveModelElementTransactionalMerger
extends DefaultTransactionalMerger {
    public Command getDoApplyInOriginCommand(TransactionalEditingDomain domain) {
        CompoundCommand cmd = new CompoundCommand("CMoveModelElementMerger#getDoApplyInOriginCommand");
        MoveModelElement theDiff = (MoveModelElement)this.diff;
        EObject leftTarget = theDiff.getLeftTarget();
        EObject leftElement = theDiff.getLeftElement();
        EReference ref = theDiff.getRightElement().eContainmentFeature();
        if (ref != null) {
            int index = -1;
            EObject rightElementParent = theDiff.getRightElement().eContainer();
            Object rightRefValue = rightElementParent.eGet((EStructuralFeature)ref);
            if (rightRefValue instanceof List) {
                List refRightValueList = (List)rightRefValue;
                index = refRightValueList.indexOf(theDiff.getRightElement());
            }
            String elementID = this.getXMIID(leftElement);
            if (rightRefValue instanceof List) {
                cmd.append(PapyrusMergeCommandProvider.INSTANCE.getMoveWithIndexCommand(domain, leftTarget, leftTarget, ref, leftElement, index, true));
            } else {
                cmd.append(PapyrusMergeCommandProvider.INSTANCE.getMoveCommand(domain, leftTarget, leftTarget, ref, leftElement));
            }
            cmd.append(this.getPreserveXMIIDCommand(domain, leftElement, elementID));
        } else {
            cmd.append((Command)UnexecutableCommand.INSTANCE);
        }
        return cmd;
    }

    public Command getDoUndoInTargetCommand(TransactionalEditingDomain domain) {
        CompoundCommand cmd = new CompoundCommand("CMoveModelElementMerger#getDoUndoInTargetCommand");
        MoveModelElement theDiff = (MoveModelElement)this.diff;
        EObject rightTarget = theDiff.getRightTarget();
        EObject rightElement = theDiff.getRightElement();
        EReference ref = theDiff.getLeftElement().eContainmentFeature();
        if (ref != null) {
            int index = -1;
            EObject leftElementParent = theDiff.getLeftElement().eContainer();
            Object leftRefValue = leftElementParent.eGet((EStructuralFeature)ref);
            if (leftRefValue instanceof List) {
                List refLeftValueList = (List)leftRefValue;
                index = refLeftValueList.indexOf(theDiff.getLeftElement());
            }
            if (leftRefValue instanceof List) {
                cmd.append(PapyrusMergeCommandProvider.INSTANCE.getMoveWithIndexCommand(domain, rightTarget, rightTarget, ref, rightElement, index, true));
            } else {
                cmd.append(PapyrusMergeCommandProvider.INSTANCE.getMoveCommand(domain, rightTarget, rightTarget, ref, rightElement));
            }
            String elementID = this.getXMIID(rightElement);
            cmd.append(this.getPreserveXMIIDCommand(domain, rightElement, elementID));
        } else {
            cmd.append((Command)UnexecutableCommand.INSTANCE);
        }
        return cmd;
    }

    private Command getPreserveXMIIDCommand(TransactionalEditingDomain domain, final EObject element, final String id) {
        return new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, "Set XMI Command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (element != null && element.eResource() instanceof XMIResource) {
                    ((XMIResource)element.eResource()).setID(element, id);
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }
}

