/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.merger;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.compare.diff.Activator;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.merger.DefaultTransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.util.PapyrusCompareEObjectCopier;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.util.PapyrusEFactory;
import org.eclipse.papyrus.infra.emf.compare.diff.service.TransactionalMergeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeLeftTargetTransactionalMerger
extends DefaultTransactionalMerger {
    @Override
    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        if (!applyInOrigin) {
            return this.diff.getRequires();
        }
        return super.getDependencies(applyInOrigin);
    }

    @Override
    public Command getDoApplyInOriginCommand(TransactionalEditingDomain domain) {
        CompoundCommand cmd = new CompoundCommand("CReferenceChangeLeftTargetMerger#getDoApplyInOriginCommand");
        final ReferenceChangeLeftTarget theDiff = (ReferenceChangeLeftTarget)this.diff;
        final EObject element = theDiff.getLeftElement();
        final EObject leftTarget = theDiff.getLeftTarget();
        try {
            cmd.append(PapyrusEFactory.getERemoveCommand(domain, element, theDiff.getReference().getName(), leftTarget));
        }
        catch (FactoryException e) {
            Activator.log.error((Throwable)e);
        }
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DiffModel diffModel = ReferenceChangeLeftTargetTransactionalMerger.this.getDiffModel();
                if (diffModel != null) {
                    TreeIterator siblings = diffModel.eAllContents();
                    while (siblings.hasNext()) {
                        Resource res;
                        ReferenceChangeLeftTarget link;
                        DiffElement op = (DiffElement)siblings.next();
                        if (op instanceof ReferenceChangeLeftTarget) {
                            link = (ReferenceChangeLeftTarget)op;
                            if (!link.getReference().equals(theDiff.getReference().getEOpposite()) || !link.getLeftTarget().equals(element)) continue;
                            ReferenceChangeLeftTargetTransactionalMerger.this.removeFromContainer((DiffElement)link);
                            continue;
                        }
                        if (!(op instanceof ResourceDependencyChange) || (res = ((EObject)(link = (ResourceDependencyChange)op).getRoots().get(0)).eResource()) != leftTarget.eResource()) continue;
                        EcoreUtil.remove((EObject)link);
                        res.unload();
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        }));
        return cmd;
    }

    @Override
    public Command getDoUndoInTargetCommand(TransactionalEditingDomain domain) {
        EObject leftElement;
        Object leftRefValue;
        CompoundCommand cmd = new CompoundCommand();
        ReferenceChangeLeftTarget theDiff = (ReferenceChangeLeftTarget)this.diff;
        final EReference reference = theDiff.getReference();
        final EObject element = theDiff.getRightElement();
        final EObject leftTarget = theDiff.getLeftTarget();
        EObject rightTarget = theDiff.getRightTarget();
        int index = -1;
        if (reference.isMany() && (leftRefValue = (leftElement = theDiff.getLeftElement()).eGet((EStructuralFeature)reference)) instanceof List) {
            List refLeftValueList = (List)leftRefValue;
            index = refLeftValueList.indexOf(leftTarget);
        }
        final PapyrusCompareEObjectCopier copier = (PapyrusCompareEObjectCopier)TransactionalMergeService.getCopier(this.diff);
        Command copierCommand = copier.getCopyReferenceValueCommand(domain, reference, element, leftTarget, rightTarget, index);
        cmd.append(copierCommand);
        AbstractTransactionalCommand updateDiffModelCommand = new AbstractTransactionalCommand(domain, "Update Diff Model", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject copiedValue = copier.getCopiedValue(leftTarget);
                TreeIterator siblings = ReferenceChangeLeftTargetTransactionalMerger.this.getDiffModel().eAllContents();
                while (siblings.hasNext()) {
                    ReferenceChangeLeftTarget link;
                    DiffElement op = (DiffElement)siblings.next();
                    if (op instanceof ReferenceChangeLeftTarget) {
                        link = (ReferenceChangeLeftTarget)op;
                        if (!link.getReference().equals(reference.getEOpposite()) || !link.getLeftTarget().equals(element)) continue;
                        ReferenceChangeLeftTargetTransactionalMerger.this.removeFromContainer((DiffElement)link);
                        continue;
                    }
                    if (!(op instanceof ReferenceOrderChange) || (link = (ReferenceOrderChange)op).getLeftElement() != element || link.getReference() != reference) continue;
                    ListIterator targetIterator = link.getLeftTarget().listIterator();
                    boolean replaced = false;
                    while (!replaced && targetIterator.hasNext()) {
                        EObject target = (EObject)targetIterator.next();
                        if (!target.eIsProxy() || !ReferenceChangeLeftTargetTransactionalMerger.equalProxyURIs(((InternalEObject)target).eProxyURI(), EcoreUtil.getURI((EObject)leftTarget))) continue;
                        targetIterator.set(copiedValue);
                        replaced = true;
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)updateDiffModelCommand));
        return cmd;
    }
}

