/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.PapyrusMergeCommandProvider;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusCompareEObjectCopier
extends EMFCompareEObjectCopier {
    private static final long serialVersionUID = -6723632034214667973L;

    public PapyrusCompareEObjectCopier(DiffResourceSet diff) {
        super(diff);
        throw new UnsupportedOperationException("not yet implemented");
    }

    public PapyrusCompareEObjectCopier(DiffModel diff) {
        super(diff);
        EObject container = diff.eContainer();
        if (container instanceof ComparisonResourceSnapshot) {
            ComparisonResourceSnapshot snapshot = (ComparisonResourceSnapshot)container;
            EList matchedElements = snapshot.getMatch().getMatchedElements();
            for (MatchElement current : matchedElements) {
                if (!(current instanceof Match2Elements)) continue;
                this.initializeCopier((Match2Elements)current);
            }
        }
    }

    protected void initializeCopier(Match2Elements matchElement) {
        EObject left = matchElement.getLeftElement();
        EObject right = matchElement.getRightElement();
        this.put(left, right);
        this.put(right, left);
        for (MatchElement current : matchElement.getSubMatchElements()) {
            if (!(current instanceof Match2Elements)) continue;
            this.initializeCopier((Match2Elements)current);
        }
    }

    public void copyXMIIDs() {
        for (Map.Entry entry : this.entrySet()) {
            EObject original = (EObject)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            if (!(original.eResource() instanceof XMIResource) || !(copy.eResource() instanceof XMIResource)) continue;
            XMIResource originResource = (XMIResource)original.eResource();
            XMIResource copyResource = (XMIResource)copy.eResource();
            if (originResource.getID(original) == null) continue;
            if (original.eResource() == copy.eResource()) {
                String currentID = originResource.getID(original);
                if (ResourceUtils.getAllResourceIds((XMIResource)copyResource).contains(currentID)) continue;
            }
            copyResource.setID(copy, originResource.getID(original));
            TreeIterator originalIterator = original.eAllContents();
            TreeIterator copyIterator = copy.eAllContents();
            while (originalIterator.hasNext()) {
                EObject nextOriginalChild = (EObject)originalIterator.next();
                EObject nextCopyChild = (EObject)copyIterator.next();
                if (nextOriginalChild.eResource() == nextCopyChild.eResource()) {
                    String currentID = originResource.getID(nextOriginalChild);
                    if (ResourceUtils.getAllResourceIds((XMIResource)copyResource).contains(currentID)) continue;
                }
                copyResource.setID(nextCopyChild, originResource.getID(nextOriginalChild));
            }
        }
    }

    public Command getCopyReferenceValueCommand(TransactionalEditingDomain domain, EReference targetReference, EObject target, EObject value, EObject matchedValue, int index) {
        EObject actualValue = value;
        if (value == null && matchedValue != null) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        if (matchedValue != null) {
            this.put(actualValue, matchedValue);
            Object referenceValue = target.eGet((EStructuralFeature)targetReference);
            if (referenceValue instanceof Collection) {
                return this.getAddAtIndexCommand(domain, target, (EStructuralFeature)targetReference, (Collection)referenceValue, matchedValue, index);
            }
            return PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, target, (EStructuralFeature)targetReference, matchedValue);
        }
        return this.getCopyValueReferenceCommand(domain, targetReference, target, actualValue, index);
    }

    private Command getCopyValueReferenceCommand(final TransactionalEditingDomain domain, final EReference targetReference, final EObject target, final EObject value, final int index) {
        GMFtoEMFCommandWrapper copyValueCommand = new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject targetValue = (EObject)PapyrusCompareEObjectCopier.this.get(value);
                EObject copy = targetValue != null ? targetValue : (value.eResource() == null || value.eResource().getURI().isPlatformPlugin() ? value : PapyrusCompareEObjectCopier.this.copy(value));
                Command cmd = null;
                Object referenceValue = target.eGet((EStructuralFeature)targetReference);
                if (referenceValue instanceof List && targetReference.isMany()) {
                    if (copy.eIsProxy() && copy instanceof InternalEObject) {
                        URI proxURI = ((InternalEObject)copy).eProxyURI();
                        boolean found = false;
                        Iterator it = ((List)referenceValue).iterator();
                        while (!found && it.hasNext()) {
                            EObject obj = (EObject)it.next();
                            if (!(obj instanceof InternalEObject)) continue;
                            found = proxURI.equals((Object)((InternalEObject)obj).eProxyURI());
                        }
                        if (!found) {
                            List targetList = (List)referenceValue;
                            cmd = PapyrusCompareEObjectCopier.this.getAddAtIndexCommand(domain, target, (EStructuralFeature)targetReference, targetList, copy, index);
                        }
                    } else {
                        List targetList = (List)referenceValue;
                        int currentIndex = targetList.indexOf(copy);
                        cmd = currentIndex == -1 ? PapyrusCompareEObjectCopier.this.getAddAtIndexCommand(domain, target, (EStructuralFeature)targetReference, targetList, copy, index) : PapyrusCompareEObjectCopier.this.getMoveAtIndexCommand(domain, target, targetList, targetReference, copy, currentIndex, index);
                    }
                } else if (copy.eIsProxy() && copy instanceof InternalEObject) {
                    URI proxURI = ((InternalEObject)copy).eProxyURI();
                    if (referenceValue instanceof InternalEObject && !proxURI.equals((Object)((InternalEObject)referenceValue).eProxyURI())) {
                        cmd = PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, target, (EStructuralFeature)targetReference, copy);
                    }
                } else {
                    cmd = PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, target, (EStructuralFeature)targetReference, copy);
                }
                if (cmd != null) {
                    cmd.execute();
                }
                return CommandResult.newOKCommandResult();
            }
        });
        return copyValueCommand;
    }

    public EObject getCopiedValue(EObject key) {
        return (EObject)this.get(key);
    }

    private Command getMoveAtIndexCommand(TransactionalEditingDomain domain, EObject target, List<EObject> targetList, EReference targetReference, EObject copy, int currentIndex, int expectedIndex) {
        ArrayList<EObject> newColl = new ArrayList<EObject>(targetList);
        int size = targetList.size();
        if (size > 1 && currentIndex >= 0 && currentIndex < size && expectedIndex != -1 && expectedIndex != currentIndex && expectedIndex <= size - 1) {
            newColl.add(expectedIndex, (EObject)newColl.remove(currentIndex));
        }
        return PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, target, (EStructuralFeature)targetReference, newColl);
    }

    private Command getAddAtIndexCommand(TransactionalEditingDomain domain, EObject editedElement, EStructuralFeature feature, Collection<EObject> collection, EObject newValue, int index) {
        ArrayList<EObject> newColl = new ArrayList<EObject>(collection);
        int listSize = collection.size();
        if (index > -1 && index < listSize) {
            newColl.add(index, newValue);
        } else {
            newColl.add(newValue);
        }
        this.attachRealPositionEAdapter(newValue, index);
        this.reorderList(newColl);
        return PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, editedElement, feature, newColl);
    }

    private void attachRealPositionEAdapter(Object object, int expectedPosition) {
        if (object instanceof EObject) {
            ((EObject)object).eAdapters().add((Object)new PositionAdapter(expectedPosition));
        }
    }

    private <T> void reorderList(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        Collections.sort(newList, new EObjectComparator());
        int i = 0;
        while (i < list.size()) {
            int oldIndex = list.indexOf(newList.get(i));
            list.add(i, list.remove(oldIndex));
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EObjectComparator<T>
    implements Comparator<T> {
        private EObjectComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof EObject && o2 instanceof EObject) {
                int position1 = this.getWantedPosition((EObject)o1);
                int position2 = this.getWantedPosition((EObject)o2);
                if (position1 != -1 && position2 != -1) {
                    return position1 - position2;
                }
            }
            return 0;
        }

        private int getWantedPosition(EObject obj1) {
            Iterator adapters = obj1.eAdapters().iterator();
            int expectedIndex = -1;
            while (expectedIndex == -1 && adapters.hasNext()) {
                Adapter adapter = (Adapter)adapters.next();
                if (!(adapter instanceof PositionAdapter)) continue;
                expectedIndex = ((PositionAdapter)adapter).getExpectedIndex();
            }
            return expectedIndex;
        }
    }

    private class PositionAdapter
    extends AdapterImpl {
        private final int expectedIndex;

        public PositionAdapter(int index) {
            this.expectedIndex = index;
        }

        public int getExpectedIndex() {
            return this.expectedIndex;
        }
    }
}

