/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.PapyrusMergeCommandProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusEFactory {
    private PapyrusEFactory() {
    }

    public static final <T> Command getEAddCommand(TransactionalEditingDomain domain, EObject object, String name, T arg) throws FactoryException {
        return PapyrusEFactory.getEAddCommand(domain, object, name, arg, -1);
    }

    public static final <T> Command getEAddCommand(TransactionalEditingDomain domain, EObject object, String name, T arg, int elementIndex) throws FactoryException {
        return PapyrusEFactory.getEAddCommand(domain, object, name, arg, elementIndex, false);
    }

    public static final <T> Command getEAddCommand(TransactionalEditingDomain domain, EObject object, String name, T arg, int elementIndex, boolean reorder) throws FactoryException {
        Command returnedCommand = null;
        EStructuralFeature feature = PapyrusEFactory.eStructuralFeature(object, name);
        if (feature.isMany() && arg != null) {
            Object manyValue = object.eGet(feature);
            if (manyValue instanceof Collection) {
                ArrayList<T> newValue = new ArrayList<T>((Collection)manyValue);
                int listSize = newValue.size();
                if (manyValue instanceof List) {
                    if (elementIndex > -1 && elementIndex < listSize) {
                        newValue.add(elementIndex, arg);
                    } else {
                        newValue.add(arg);
                    }
                    if (reorder) {
                        PapyrusEFactory.attachRealPositionEAdapter(arg, elementIndex);
                        PapyrusEFactory.reorderList(newValue);
                    }
                } else if (manyValue instanceof Collection) {
                    newValue.add(arg);
                }
                returnedCommand = PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, object, feature, newValue);
            }
        } else if (!feature.isMany()) {
            returnedCommand = PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, object, feature, arg);
        }
        return returnedCommand;
    }

    public static final Command getERemoveCommand(TransactionalEditingDomain domain, EObject object, String name, Object arg) throws FactoryException {
        Object list = object.eGet(PapyrusEFactory.eStructuralFeature(object, name));
        if (list instanceof List) {
            if (arg != null) {
                ArrayList newValue = new ArrayList((List)list);
                newValue.remove(arg);
                return PapyrusEFactory.getESetCommand(domain, object, name, newValue);
            }
        } else {
            return PapyrusEFactory.getESetCommand(domain, object, name, null);
        }
        return null;
    }

    public static final Command getESetCommand(TransactionalEditingDomain domain, EObject object, String name, Object arg) throws FactoryException {
        Command returnedCommand;
        EStructuralFeature feature = PapyrusEFactory.eStructuralFeature(object, name);
        if (!feature.isChangeable()) {
            throw new FactoryException(EMFCompareMessages.getString((String)"EFactory.UnSettableFeature", (Object[])new Object[]{name}));
        }
        if (feature.getEType() instanceof EEnum && arg instanceof String) {
            EEnumLiteral literal = ((EEnum)feature.getEType()).getEEnumLiteral((String)arg);
            returnedCommand = PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, object, feature, literal);
        } else {
            returnedCommand = arg == null && feature.isMany() ? PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, object, feature, Collections.EMPTY_LIST) : (arg == null ? PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, object, feature, feature.getDefaultValue()) : PapyrusMergeCommandProvider.INSTANCE.getSetCommand(domain, object, feature, arg));
        }
        return returnedCommand;
    }

    public static EStructuralFeature eStructuralFeature(EObject object, String name) throws FactoryException {
        return EFactory.eStructuralFeature((EObject)object, (String)name);
    }

    private static void attachRealPositionEAdapter(Object object, int expectedPosition) {
        if (object instanceof EObject) {
            ((EObject)object).eAdapters().add((Object)new PositionAdapter(expectedPosition));
        }
    }

    private static <T> void reorderList(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        Collections.sort(newList, new EObjectComparator());
        int i = 0;
        while (i < list.size()) {
            int oldIndex = list.indexOf(newList.get(i));
            list.add(i, list.remove(oldIndex));
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EObjectComparator<T>
    implements Comparator<T> {
        private EObjectComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof EObject && o2 instanceof EObject) {
                int position1 = this.getWantedPosition((EObject)o1);
                int position2 = this.getWantedPosition((EObject)o2);
                if (position1 != -1 && position2 != -1) {
                    return position1 - position2;
                }
            }
            return 0;
        }

        private int getWantedPosition(EObject obj1) {
            Iterator adapters = obj1.eAdapters().iterator();
            int expectedIndex = -1;
            while (expectedIndex == -1 && adapters.hasNext()) {
                Adapter adapter = (Adapter)adapters.next();
                if (!(adapter instanceof PositionAdapter)) continue;
                expectedIndex = ((PositionAdapter)adapter).getExpectedIndex();
            }
            return expectedIndex;
        }
    }

    private static class PositionAdapter
    extends AdapterImpl {
        private final int expectedIndex;

        public PositionAdapter(int index) {
            this.expectedIndex = index;
        }

        public int getExpectedIndex() {
            return this.expectedIndex;
        }
    }
}

