/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.diff.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.IMergeListener;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.MergeEvent;
import org.eclipse.emf.compare.diff.merge.service.MergeFactory;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.FireMergeDiffEndCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.FireMergeDiffStartCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.FireMergeOperationEndCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.command.FireMergeOperationStartCommand;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.merger.DiffGroupTransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.internal.util.PapyrusCompareEObjectCopier;
import org.eclipse.papyrus.infra.emf.compare.diff.merge.ITransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.service.TransactionalMergeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalMergeService {
    private static EMFCompareEObjectCopier copier;
    private static final List<IMergeListener> MERGE_LISTENERS;

    static {
        MERGE_LISTENERS = new ArrayList<IMergeListener>();
    }

    private TransactionalMergeService() {
    }

    public static Command getMergeCommand(TransactionalEditingDomain domain, DiffElement element, boolean leftToRight) {
        CompoundCommand cmd = new CompoundCommand("MergeCommand");
        cmd.append((Command)new FireMergeOperationStartCommand(element, TransactionalMergeService.getMergeListeners()));
        cmd.append(TransactionalMergeService.getDoMergeCommand(domain, element, leftToRight));
        cmd.append((Command)new FireMergeOperationEndCommand(element, TransactionalMergeService.getMergeListeners()));
        return cmd;
    }

    private static Command getDoMergeCommand(TransactionalEditingDomain domain, DiffElement element, boolean leftToRight) {
        ITransactionalMerger merger;
        CompoundCommand cmd = new CompoundCommand("DoMergeCommand");
        cmd.append((Command)new FireMergeDiffStartCommand(element, TransactionalMergeService.getMergeListeners()));
        if (element instanceof DiffGroup) {
            merger = new DiffGroupTransactionalMerger();
            merger.setDiffElement(element);
        } else {
            merger = element instanceof ConflictingDiffElement ? TransactionalMergeFactory.createMerger((DiffElement)element.getSubDiffElements().get(0)) : TransactionalMergeFactory.createMerger(element);
        }
        if (merger instanceof ITransactionalMerger) {
            if (leftToRight) {
                cmd.append(merger.getUndoInTargetCommand(domain));
            } else {
                cmd.append(merger.getApplyInOriginCommand(domain));
            }
        } else {
            throw new UnsupportedOperationException(NLS.bind((String)"I can't found the Papyrus Merger for {0}.", (Object)element));
        }
        cmd.append((Command)new FireMergeDiffEndCommand(element, TransactionalMergeService.getMergeListeners()));
        return cmd;
    }

    public static void merge(TransactionalEditingDomain domain, DiffElement element, boolean leftToRight) {
        Command cmd = TransactionalMergeService.getMergeCommand(domain, element, leftToRight);
        domain.getCommandStack().execute(cmd);
    }

    public static void merge(TransactionalEditingDomain domain, List<DiffElement> elements, boolean leftToRight) {
        Command cmd = TransactionalMergeService.getMergeCommand(domain, elements, leftToRight);
        domain.getCommandStack().execute(cmd);
    }

    public static Command getMergeCommand(TransactionalEditingDomain domain, List<DiffElement> elements, boolean leftToRight) {
        CompoundCommand cmd = new CompoundCommand("MergeCommand");
        cmd.append((Command)new FireMergeOperationStartCommand(elements, TransactionalMergeService.getMergeListeners()));
        for (DiffElement element : new ArrayList<DiffElement>(elements)) {
            if (element.eContainer() == null) continue;
            cmd.append(TransactionalMergeService.getDoMergeCommand(domain, element, leftToRight));
        }
        cmd.append((Command)new FireMergeOperationEndCommand(elements, TransactionalMergeService.getMergeListeners()));
        return cmd;
    }

    private static List<IMergeListener> getMergeListeners() {
        return MERGE_LISTENERS;
    }

    public static void addMergeListener(IMergeListener listener) {
        MERGE_LISTENERS.add(listener);
    }

    public static EMFCompareEObjectCopier getCopier(DiffElement diff) {
        DiffModel diffModel = TransactionalMergeService.getContainerDiffModel(diff);
        if (diffModel == null) {
            throw new IllegalArgumentException("The diff element should be contained in a DiffModel instance");
        }
        if (diffModel.eContainer() instanceof DiffResourceSet) {
            if (copier == null) {
                copier = new PapyrusCompareEObjectCopier((DiffResourceSet)diffModel.eContainer());
            } else if (copier.getDiffResourceSet() != diffModel.eContainer()) {
                copier.clear();
                copier = new PapyrusCompareEObjectCopier((DiffResourceSet)diffModel.eContainer());
            }
        } else if (copier == null) {
            copier = new PapyrusCompareEObjectCopier(diffModel);
        } else if (copier.getDiffModel() != diffModel) {
            copier.clear();
            copier = new PapyrusCompareEObjectCopier(diffModel);
        }
        return copier;
    }

    private static DiffModel getContainerDiffModel(DiffElement diff) {
        EObject container = diff.eContainer();
        while (container != null) {
            if (container instanceof DiffModel) {
                return (DiffModel)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static void merge(DiffElement element, boolean leftToRight) {
        TransactionalMergeService.fireMergeOperationStart(element);
        TransactionalMergeService.doMerge(element, leftToRight);
        TransactionalMergeService.fireMergeOperationEnd(element);
    }

    public static void merge(List<DiffElement> elements, boolean leftToRight) {
        TransactionalMergeService.fireMergeOperationStart(elements);
        for (DiffElement element : new ArrayList<DiffElement>(elements)) {
            if (element.eContainer() == null) continue;
            TransactionalMergeService.doMerge(element, leftToRight);
        }
        TransactionalMergeService.fireMergeOperationEnd(elements);
    }

    public static void removeMergeListener(IMergeListener listener) {
        MERGE_LISTENERS.remove(listener);
    }

    protected static void doMerge(DiffElement element, boolean leftToRight) {
        TransactionalMergeService.fireMergeDiffStart(element);
        IMerger merger = element instanceof ConflictingDiffElement ? MergeFactory.createMerger((DiffElement)((DiffElement)element.getSubDiffElements().get(0))) : MergeFactory.createMerger((DiffElement)element);
        if (leftToRight && merger.canUndoInTarget()) {
            merger.undoInTarget();
        } else if (!leftToRight && merger.canApplyInOrigin()) {
            merger.applyInOrigin();
        }
        TransactionalMergeService.fireMergeDiffEnd(element);
    }

    protected static void fireMergeDiffEnd(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeDiffEnd(new MergeEvent(diff));
        }
    }

    protected static void fireMergeDiffStart(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeDiffStart(new MergeEvent(diff));
        }
    }

    protected static void fireMergeOperationEnd(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationEnd(new MergeEvent(diff));
        }
    }

    protected static void fireMergeOperationEnd(List<DiffElement> diffs) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationEnd(new MergeEvent(diffs));
        }
    }

    protected static void fireMergeOperationStart(DiffElement diff) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationStart(new MergeEvent(diff));
        }
    }

    protected static void fireMergeOperationStart(List<DiffElement> diffs) {
        for (IMergeListener listener : MERGE_LISTENERS) {
            listener.mergeOperationStart(new MergeEvent(diffs));
        }
    }
}

