/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.CustomizationAndViewerActionDispatcher;
import org.eclipse.papyrus.infra.emf.compare.ui.messages.Messages;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationAction
extends Action {
    private static final String TOOLTIPTEXT = Messages.CustomizationAction_ManageAppliedCustomization;
    private static final String CUSTOMIZATION_IMAGE_PATH = "icons/add_ui_custom.gif";
    private final Collection<EPackage> registeredMetamodel;

    public CustomizationAction(Collection<EPackage> registeredMetamodel) {
        super("toolTipText", 1);
        this.setToolTipText(TOOLTIPTEXT);
        ImageDescriptor desc = Activator.getDefault().getImageDescriptor("org.eclipse.papyrus.infra.emf.compare.ui", CUSTOMIZATION_IMAGE_PATH);
        this.setImageDescriptor(desc);
        this.registeredMetamodel = registeredMetamodel;
    }

    public void run() {
        IEditorPart currentEditor = EditorHelper.getCurrentEditor();
        if (currentEditor instanceof IMultiPageEditorPart) {
            currentEditor = ((IMultiPageEditorPart)currentEditor).getActiveEditor();
        }
        CustomizationManager customizationManager = CustomizationAndViewerActionDispatcher.getCustomizationManager(currentEditor);
        assert (customizationManager != null);
        List initiallySelectedCustomizations = customizationManager.getRegisteredCustomizations();
        LoadCustomizationsDialog loadCustomizationsDialog = new LoadCustomizationsDialog(Display.getCurrent().getActiveShell(), initiallySelectedCustomizations, this.registeredMetamodel);
        if (loadCustomizationsDialog.open() == 0) {
            customizationManager.clearCustomizations();
            List selectedCustomizations = loadCustomizationsDialog.getSelectedCustomizations();
            customizationManager.clearFacets();
            loadCustomizationsDialog.isLoadRequiredFacetsSelected();
            for (MetamodelView metamodelView : selectedCustomizations) {
                customizationManager.registerCustomization(metamodelView);
            }
            customizationManager.loadCustomizations();
        }
        if (currentEditor instanceof IPropertyChangeListener) {
            ((IPropertyChangeListener)currentEditor).propertyChange(new PropertyChangeEvent(IAction.class, CompareEditorInput.PROP_TITLE, (Object)"", (Object)""));
        }
        CustomizationAndViewerActionDispatcher.refreshViewers(currentEditor);
    }
}

