/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.content.transactional.viewer;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.papyrus.infra.emf.compare.diff.merge.ITransactionalMerger;
import org.eclipse.papyrus.infra.emf.compare.diff.service.TransactionalMergeFactory;
import org.eclipse.papyrus.infra.emf.compare.ui.content.viewer.PapyrusCustomizableModelContentMergeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PapyrusTransactionalModelContentMergeViewer
extends PapyrusCustomizableModelContentMergeViewer {
    private IAction _copyDiffLeftToRight;
    private IAction _copyDiffRightToLeft;
    private IAction _copyAllLeftToRight;
    private IAction _copyAllRightToLeft;
    private static final String COPY_ALL_RIGHT_TO_LEFT = "org.eclipse.compare.copyAllRightToLeft";
    private static final String COPY_ALL_LEFT_TO_RIGHT = "org.eclipse.compare.copyAllLeftToRight";
    private static final String COPY_CURRENT_SELECTION_LEFT_TO_RIGHT = "Copy Current Change to Right";
    private static final String COPY_CURRENT_SELECTION_RIGHT_TO_LEFT = "Copy Current Change to Left";

    public PapyrusTransactionalModelContentMergeViewer(Composite parent, CompareConfiguration config, IEditorPart editor) {
        super(parent, config, editor);
    }

    protected void createToolItems(ToolBarManager tbm) {
        super.createToolItems(tbm);
        final UndoActionWrapper undoAction = new UndoActionWrapper();
        final RedoActionWrapper redoAction = new RedoActionWrapper();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                undoAction.setActiveWorkbenchPart((IWorkbenchPart)editorPart);
                redoAction.setActiveWorkbenchPart((IWorkbenchPart)editorPart);
            }
        });
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        tbm.insert(0, (IContributionItem)new ActionContributionItem((IAction)undoAction));
        tbm.insert(1, (IContributionItem)new ActionContributionItem((IAction)redoAction));
        tbm.insert(2, (IContributionItem)new Separator("undo_redo_group"));
        this.initializeIActionField(tbm);
    }

    /*
     * Unable to fully structure code
     */
    private void initializeIActionField(ToolBarManager tbm) {
        var5_2 = tbm.getItems();
        var4_3 = var5_2.length;
        var3_4 = 0;
        while (var3_4 < var4_3) {
            item = var5_2[var3_4];
            if (!(item instanceof ActionContributionItem)) ** GOTO lbl-1000
            action = ((ActionContributionItem)item).getAction();
            id = action.getActionDefinitionId();
            txt = action.getText();
            if ("org.eclipse.compare.copyAllLeftToRight".equals(id)) {
                this._copyAllLeftToRight = action;
            } else if ("org.eclipse.compare.copyAllRightToLeft".equals(id)) {
                this._copyAllRightToLeft = action;
            } else if ("Copy Current Change to Right".equals(txt)) {
                this._copyDiffLeftToRight = action;
            } else if ("Copy Current Change to Left".equals(txt)) {
                this._copyDiffRightToLeft = action;
            } else if (this._copyAllLeftToRight != null && this._copyAllRightToLeft != null && this._copyDiffLeftToRight != null && this._copyDiffRightToLeft != null) break;
            ++var3_4;
        }
    }

    protected void switchCopyState(boolean enabled) {
        ModelComparator comparator = ModelComparator.getComparator((CompareConfiguration)this.configuration);
        boolean leftEditable = this.configuration.isLeftEditable();
        if (comparator != null) {
            leftEditable = leftEditable && !comparator.isLeftRemote();
        }
        boolean rightEditable = this.configuration.isRightEditable();
        if (comparator != null) {
            rightEditable = rightEditable && !comparator.isRightRemote();
        }
        boolean canCopyLeftToRight = false;
        boolean canCopyRightToLeft = false;
        boolean canAllCopyLeftToRight = true;
        boolean canAllCopyRightToLeft = true;
        if (this.currentSelection.size() == 1) {
            ITransactionalMerger merger = TransactionalMergeFactory.createMerger((DiffElement)((DiffElement)this.currentSelection.get(0)));
            canCopyLeftToRight = merger.canUndoInTarget();
            canCopyRightToLeft = merger.canApplyInOrigin();
        }
        if (this.currentSelection.size() > 0) {
            EObject diffModel = (EObject)this.currentSelection.get(0);
            while (!(diffModel instanceof DiffModel)) {
                diffModel = diffModel.eContainer();
            }
            Assert.isNotNull((Object)diffModel);
            for (DiffElement current : ((DiffModel)diffModel).getDifferences()) {
                ITransactionalMerger merger = TransactionalMergeFactory.createMerger((DiffElement)current);
                canAllCopyLeftToRight = canAllCopyLeftToRight && merger.canUndoInTarget();
                boolean bl = canAllCopyRightToLeft = canAllCopyRightToLeft && merger.canApplyInOrigin();
            }
        }
        if (this._copyAllLeftToRight != null) {
            this._copyAllLeftToRight.setEnabled(rightEditable && enabled && canAllCopyLeftToRight);
        }
        if (this._copyAllRightToLeft != null) {
            this._copyAllRightToLeft.setEnabled(leftEditable && enabled && canAllCopyRightToLeft);
        }
        if (this._copyDiffLeftToRight != null) {
            this._copyDiffLeftToRight.setEnabled(rightEditable && enabled && canCopyLeftToRight);
        }
        if (this._copyDiffRightToLeft != null) {
            this._copyDiffRightToLeft.setEnabled(leftEditable && enabled && canCopyRightToLeft);
        }
    }
}

