/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.content.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.actions.CollapseAllAction;
import org.eclipse.papyrus.infra.emf.compare.ui.actions.CustomizationAction;
import org.eclipse.papyrus.infra.emf.compare.ui.actions.ExpandAllAction;
import org.eclipse.papyrus.infra.emf.compare.ui.content.viewer.PapyrusModelContentMergeTabFolder;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.CustomizationAndViewerActionDispatcher;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.EMFCompareUIUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;

public class PapyrusCustomizableModelContentMergeViewer
extends ModelContentMergeViewer {
    private Collection<EPackage> metamodels;

    public PapyrusCustomizableModelContentMergeViewer(Composite parent, CompareConfiguration config, IEditorPart editor) {
        super(parent, config);
        LabelProvider labelProvider = CustomizationAndViewerActionDispatcher.getLabelProvider(editor);
        ((PapyrusModelContentMergeTabFolder)this.leftPart).setLabelProvider(labelProvider);
        ((PapyrusModelContentMergeTabFolder)this.rightPart).setLabelProvider(labelProvider);
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.metamodels = EMFCompareUIUtils.getMetamodelForCustomization(input, this.metamodels);
        this.updateToolItems();
    }

    protected ModelContentMergeTabFolder createModelContentMergeTabFolder(Composite composite, int side) {
        return new PapyrusModelContentMergeTabFolder(this, composite, side);
    }

    protected void createToolItems(ToolBarManager tbm) {
        if (this.metamodels == null) {
            this.metamodels = new HashSet<EPackage>();
        }
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        viewers.add((TreeViewer)this.rightPart.getTreePart());
        viewers.add((TreeViewer)this.leftPart.getTreePart());
        ExpandAllAction expandAllAction = new ExpandAllAction(viewers);
        ActionContributionItem expandAllContributionItem = new ActionContributionItem((IAction)expandAllAction);
        tbm.insert(0, (IContributionItem)expandAllContributionItem);
        CollapseAllAction collapseAllAction = new CollapseAllAction(viewers);
        ActionContributionItem collapseAllActionContributionItem = new ActionContributionItem((IAction)collapseAllAction);
        tbm.insert(1, (IContributionItem)collapseAllActionContributionItem);
        tbm.insert(2, (IContributionItem)new Separator("treeAction"));
        CustomizationAction customizationAction = new CustomizationAction(Collections.unmodifiableCollection(this.metamodels));
        ActionContributionItem customizationContributionItem = new ActionContributionItem((IAction)customizationAction);
        tbm.insert(3, (IContributionItem)customizationContributionItem);
        super.createToolItems(tbm);
    }

    protected void handleDispose(DisposeEvent event) {
        this.metamodels.clear();
        super.handleDispose(event);
    }
}

