/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.content.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.IModelContentMergeViewerTab;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.compare.ui.viewer.content.part.diff.ModelContentMergeDiffTab;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.content.viewer.PapyrusCustomizableModelContentMergeViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.CustomizationAndViewerActionDispatcher;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PapyrusModelContentMergeTabFolder
extends ModelContentMergeTabFolder {
    protected final PapyrusCustomizableModelContentMergeViewer myUMLViewer;
    private LabelProvider labelProvider;
    protected ModelContentMergeDiffTab diffTab;

    public PapyrusModelContentMergeTabFolder(ModelContentMergeViewer viewer, Composite composite, int side) {
        super(viewer, composite, side);
        this.myUMLViewer = (PapyrusCustomizableModelContentMergeViewer)viewer;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        CustomizationAndViewerActionDispatcher.associateViewerAndLabelProvider((TreeViewer)this.diffTab, this.labelProvider);
        this.diffTab.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected IModelContentMergeViewerTab createModelContentMergeDiffTab(Composite parent) {
        this.diffTab = new ModelContentMergeDiffTab(parent, this.partSide, (ModelContentMergeTabFolder)this);
        this.diffTab.setContentProvider(this.createDiffTabContentProvider());
        return this.diffTab;
    }

    protected void createContents(Composite composite) {
        super.createContents(composite);
        Control ctrl = this.tree.getControl();
        ctrl.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void dispose() {
        if (this.labelProvider != null) {
            CustomizationAndViewerActionDispatcher.dissociateTreeViewerAndLabelProvider((TreeViewer)this.diffTab, this.labelProvider);
            this.diffTab = null;
            this.labelProvider = null;
        }
        super.dispose();
    }

    protected IContentProvider createDiffTabContentProvider() {
        return new ModelContentMergeDiffTabContentProvider(AdapterUtils.getAdapterFactory());
    }

    protected class ModelContentMergeDiffTabContentProvider
    extends AdapterFactoryContentProvider {
        public ModelContentMergeDiffTabContentProvider(AdapterFactory factory) {
            super(factory);
        }

        public Object[] getElements(Object object) {
            Object[] result = null;
            if (object instanceof ResourceSet) {
                EList resources = ((ResourceSet)object).getResources();
                ArrayList<Resource> elements = new ArrayList<Resource>(resources.size());
                for (Resource resource : resources) {
                    if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof ComparisonSnapshot) continue;
                    elements.add(resource);
                }
                result = elements.toArray();
            } else {
                result = object instanceof List ? ((List)object).toArray() : super.getElements(object);
            }
            return result;
        }
    }
}

