/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.internal.utils;

import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.EMFCompareLabelProviderRefreshingViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.ILabelProviderRefreshingViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.LabelProviderUtil;
import org.eclipse.papyrus.infra.emf.compare.ui.provider.EMFCompareLabelProvider;
import org.eclipse.papyrus.infra.emf.compare.ui.utils.ICustomizableEditor;
import org.eclipse.ui.IEditorPart;

public class CustomizationAndViewerActionDispatcher {
    private CustomizationAndViewerActionDispatcher() {
    }

    public static LabelProvider getLabelProvider(IEditorPart editor) {
        if (editor instanceof ICustomizableEditor) {
            return ((ICustomizableEditor)editor).getLabelProvider();
        }
        return LabelProviderUtil.INSTANCE.getLabelProviderFor(editor);
    }

    public static LabelProvider getExistingLabelProvider(IEditorPart editor) {
        if (editor instanceof ICustomizableEditor) {
            return ((ICustomizableEditor)editor).getLabelProvider();
        }
        return LabelProviderUtil.INSTANCE.getExistingLabelProviderFor(editor);
    }

    public static CustomizationManager getCustomizationManager(IEditorPart editor) {
        if (editor instanceof ICustomizableEditor) {
            EMFCompareLabelProvider provider = ((ICustomizableEditor)editor).getLabelProvider();
            return provider.getCustomizationManager();
        }
        EMFCompareLabelProviderRefreshingViewer provider = LabelProviderUtil.INSTANCE.getExistingLabelProviderFor(editor);
        return provider.getCustomizationManager();
    }

    public static void refreshViewers(IEditorPart editor) {
        if (editor instanceof ICustomizableEditor) {
            ((ICustomizableEditor)editor).refreshViewers();
        } else {
            EMFCompareLabelProviderRefreshingViewer provider = LabelProviderUtil.INSTANCE.getExistingLabelProviderFor(editor);
            provider.refreshViewer();
        }
    }

    public static void dissociateTreeViewerAndLabelProvider(TreeViewer viewer, LabelProvider provider) {
        if (provider instanceof ILabelProviderRefreshingViewer) {
            ((ILabelProviderRefreshingViewer)provider).unregisterViewer(viewer);
        }
    }

    public static void associateViewerAndLabelProvider(TreeViewer viewer, LabelProvider provider) {
        if (provider instanceof ILabelProviderRefreshingViewer) {
            ((ILabelProviderRefreshingViewer)provider).registerViewer(viewer);
        }
    }
}

