/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.internal.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.papyrus.infra.emf.compare.ui.Activator;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.EMFCompareLabelProviderRefreshingViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.messages.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

class LabelProviderUtil {
    private final Map<IEditorPart, EMFCompareLabelProviderRefreshingViewer> labelProviderMap = new HashMap<IEditorPart, EMFCompareLabelProviderRefreshingViewer>();
    private final Map<IEditorPart, CustomizationManager> customizationMap = new HashMap<IEditorPart, CustomizationManager>(){

        @Override
        public String toString() {
            String str = super.toString();
            return str.replaceAll(", ", "\n");
        }
    };
    public static final LabelProviderUtil INSTANCE = new LabelProviderUtil();

    private LabelProviderUtil() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)new CloseCompareEditorListener());
    }

    public EMFCompareLabelProviderRefreshingViewer getLabelProviderFor(IEditorPart editor) {
        if (editor instanceof IMultiPageEditorPart) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.LabelProviderUtil_CantProvideLabelProviderMessage, IMultiPageEditorPart.class));
        }
        EMFCompareLabelProviderRefreshingViewer provider = this.labelProviderMap.get(editor);
        if (provider == null) {
            CustomizationManager customizationManager = this.getCustomizationManager(editor);
            provider = new EMFCompareLabelProviderRefreshingViewer(customizationManager);
            this.labelProviderMap.put(editor, provider);
        }
        return provider;
    }

    public EMFCompareLabelProviderRefreshingViewer getExistingLabelProviderFor(IEditorPart editor) throws NullPointerException {
        if (editor instanceof IMultiPageEditorPart) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.LabelProviderUtil_CantProvideLabelProviderMessage, IMultiPageEditorPart.class));
        }
        EMFCompareLabelProviderRefreshingViewer provider = this.labelProviderMap.get(editor);
        if (provider == null) {
            throw new NullPointerException();
        }
        return provider;
    }

    public void destroyConfigurationFor(IEditorPart editor) {
        this.labelProviderMap.remove(editor);
        this.customizationMap.remove(editor);
    }

    private void init(CustomizationManager customizationManager) {
        customizationManager.setShowDerivedLinks(true);
        try {
            List registryDefaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
            for (MetamodelView metamodelView : registryDefaultCustomizations) {
                customizationManager.registerCustomization(metamodelView);
            }
            customizationManager.loadCustomizations();
        }
        catch (Throwable e) {
            Activator.log.error(e);
        }
    }

    public CustomizationManager getCustomizationManager(IEditorPart anEditor) {
        CustomizationManager manager = this.customizationMap.get(anEditor);
        if (manager == null) {
            manager = new CustomizationManager();
            this.init(manager);
            this.customizationMap.put(anEditor, manager);
        }
        return manager;
    }

    public class CloseCompareEditorListener
    implements IPartListener {
        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof CompareEditor) {
                LabelProviderUtil.this.customizationMap.remove(part);
                LabelProviderUtil.this.labelProviderMap.remove(part);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

