/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelLabelProvider;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.emf.facet.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.papyrus.infra.emf.compare.ui.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class EMFCompareLabelProvider
extends CustomizableModelLabelProvider {
    private final AppearanceConfiguration configuration;
    private final CustomizationManager manager;

    public EMFCompareLabelProvider(CustomizationManager customizationManager) {
        super(customizationManager);
        this.manager = customizationManager;
        this.configuration = this.getAppearanceConfiguration(customizationManager);
    }

    private AppearanceConfiguration getAppearanceConfiguration(CustomizationManager customizationManager2) {
        try {
            Method getApperanceConfigurationMethod = CustomizationManager.class.getDeclaredMethod("getAppearanceConfiguration", new Class[0]);
            if (getApperanceConfigurationMethod != null) {
                getApperanceConfigurationMethod.setAccessible(true);
                return (AppearanceConfiguration)getApperanceConfigurationMethod.invoke((Object)customizationManager2, new Object[0]);
            }
        }
        catch (SecurityException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        return new AppearanceConfiguration(null);
    }

    public String getText(Object element) {
        String text = "";
        if (element != null) {
            if (element instanceof IFile) {
                text = ((IFile)element).getName();
            } else if (element instanceof Resource) {
                text = ((Resource)element).getURI().lastSegment();
            }
            if (element instanceof EObject) {
                ITreeElement treeElement = this.getTreeElement((EObject)element);
                text = super.getText((Object)treeElement);
            } else {
                text = super.getText(element);
            }
        } else {
            text = "null";
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof IFile) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        } else if (element instanceof EObject) {
            ITreeElement treeElement = this.getTreeElement((EObject)element);
            image = super.getImage((Object)treeElement);
        } else {
            image = super.getImage(element);
        }
        return image;
    }

    private ITreeElement getTreeElement(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return new ModelElementItem(eObject, this.getTreeElement(eObject.eContainer()), this.configuration);
    }

    public CustomizationManager getCustomizationManager() {
        return this.manager;
    }
}

